<?php
/**
 * فیلتر دیدگاه‌های SpamLite، نسخه ساده‌شده SmartSpam
 * 
 * @package SpamLite
 * @author YoviSun وبلاگ تائو شیائوتائو
 * @version 0.0.2
 * @link http://www.52txr.cn
 */

class SpamLite_Plugin implements Typecho_Plugin_Interface
{
    public static function activate()
    {
        Typecho_Plugin::factory('Widget_Feedback')->comment = array('SpamLite_Plugin', 'filter');
        return _t('پلاگین SpamLite با موفقیت فعال شد، لطفا محتوای مورد دیدگاه برای فیلتر کردن را پیکربندی کنید');
    }

    public static function deactivate(){}

    public static function config(Typecho_Widget_Helper_Form $form)
    {
        $opt_sensitive_words = new Typecho_Widget_Helper_Form_Element_Radio('opt_sensitive_words',
            array("none" => "بدون اقدام", "waiting" => "علامت‌گذاری به عنوان در انتظار بررسی", "abandon" => "دیدگاه ناموفق"), "none",
            _t('عملیات برای کلمات حساس'), "اگر دیدگاه شامل کلمات موجود در لیست کلمات حساس باشد، این عمل انجام خواهد شد");
        $form->addInput($opt_sensitive_words);

        $words_sensitive = new Typecho_Widget_Helper_Form_Element_Textarea('words_sensitive', NULL, "",
            _t('کلمات حساس'), _t('لطفا کلمات متعدد را با خط جدید جدا کنید'));
        $form->addInput($words_sensitive);

        $opt_no_chinese = new Typecho_Widget_Helper_Form_Element_Radio('opt_no_chinese',
            array("none" => "بدون اقدام", "waiting" => "علامت‌گذاری به عنوان در انتظار بررسی", "abandon" => "دیدگاه ناموفق"), "none",
            _t('عملیات برای دیدگاه‌های غیرفارسی'), "اگر دیدگاه شامل متن فارسی نباشد، این عمل انجام خواهد شد");
        $form->addInput($opt_no_chinese);

        $opt_sensitive_nickname = new Typecho_Widget_Helper_Form_Element_Radio('opt_sensitive_nickname',
            array("none" => "بدون اقدام", "waiting" => "علامت‌گذاری به عنوان در انتظار بررسی", "abandon" => "دیدگاه ناموفق"), "none",
            _t('عملیات برای نام‌های کاربری حساس'), "اگر نام کاربری ارسال‌کننده‌دیدگاه شامل کلمات موجود در لیست کلمات حساس باشد، این عمل انجام خواهد شد");
        $form->addInput($opt_sensitive_nickname);

        $words_sensitive_nickname = new Typecho_Widget_Helper_Form_Element_Textarea('words_sensitive_nickname', NULL, "",
            _t('کلمات حساس برای نام کاربری'), _t('لطفا کلمات متعدد را با خط جدید جدا کنید'));
        $form->addInput($words_sensitive_nickname);

        $opt_sensitive_url = new Typecho_Widget_Helper_Form_Element_Radio('opt_sensitive_url',
            array("none" => "بدون اقدام", "waiting" => "علامت‌گذاری به عنوان در انتظار بررسی", "abandon" => "دیدگاه ناموفق"), "none",
            _t('عملیات برای آدرس‌های وب حساس'), "اگر آدرس وب ارسال‌کننده‌دیدگاه شامل کلمات موجود در لیست کلمات حساس باشد، این عمل انجام خواهد شد");
        $form->addInput($opt_sensitive_url);

        $words_sensitive_url = new Typecho_Widget_Helper_Form_Element_Textarea('words_sensitive_url', NULL, "",
            _t('کلمات حساس برای آدرس وب'), _t('لطفا کلمات متعدد را با خط جدید جدا کنید'));
        $form->addInput($words_sensitive_url);

        $opt_sensitive_email = new Typecho_Widget_Helper_Form_Element_Radio('opt_sensitive_email',
            array("none" => "بدون اقدام", "waiting" => "علامت‌گذاری به عنوان در انتظار بررسی", "abandon" => "دیدگاه ناموفق"), "none",
            _t('عملیات برای ایمیل‌های حساس'), "اگر ایمیل ارسال‌کننده‌دیدگاه شامل کلمات موجود در لیست کلمات حساس باشد، این عمل انجام خواهد شد");
        $form->addInput($opt_sensitive_email);

        $words_sensitive_email = new Typecho_Widget_Helper_Form_Element_Textarea('words_sensitive_email', NULL, "",
            _t('کلمات حساس برای ایمیل'), _t('لطفا کلمات متعدد را با خط جدید جدا کنید'));
        $form->addInput($words_sensitive_email);
    }

    public static function personalConfig(Typecho_Widget_Helper_Form $form){}

    public static function filter($comments, $post, $last)
    {
        $comment = empty($last) ? $comments : $last;
        $options = Typecho_Widget::widget('Widget_Options');
        $user = Typecho_Widget::widget('Widget_User');
        $filter_set = $options->plugin('SpamLite');
        $opt = "none";
        $error = "";

        // بررسی کلمات حساس
        if ($opt == "none" && $filter_set->opt_sensitive_words != "none") {
            if (SpamLite_Plugin::check_in($filter_set->words_sensitive, $comment['text'])) {
                $error = "محتوای دیدگاه شامل کلمات حساس است";
                $opt = $filter_set->opt_sensitive_words;
            }
        }

        // پردازش دیدگاه‌های غیرفارسی
        if ($opt == "none" && $filter_set->opt_no_chinese != "none") {
            if (preg_match("/[\x{600}-\x{6FF}]/u", $comment['text']) == 0) {
                $error = "لطفا محتوای دیدگاه شامل حداقل یک کلمه فارسی باشد";
                $opt = $filter_set->opt_no_chinese;
            }
        }

        // بررسی نام کاربری حساس
        if ($opt == "none" && $filter_set->opt_sensitive_nickname != "none") {
            if (SpamLite_Plugin::check_in($filter_set->words_sensitive_nickname, $comment['author'])) {
                $error = "نام کاربری ارسال‌کننده‌دیدگاه شامل کلمات حساس است";
                $opt = $filter_set->opt_sensitive_nickname;
            }
        }
        
        // بررسی آدرس وب حساس
        if ($opt == "none" && $filter_set->opt_sensitive_url != "none" && !empty($comment['url'])) {
            if (SpamLite_Plugin::check_in($filter_set->words_sensitive_url, $comment['url'])) {
                $error = "آدرس وب ارسال‌کننده‌دیدگاه شامل کلمات حساس است";
                $opt = $filter_set->opt_sensitive_url;
            }
        }

        // بررسی ایمیل حساس
        if ($opt == "none" && $filter_set->opt_sensitive_email != "none" && !empty($comment['mail'])) {
            if (SpamLite_Plugin::check_in($filter_set->words_sensitive_email, $comment['mail'])) {
                $error = "ایمیل ارسال‌کننده‌دیدگاه شامل کلمات حساس است";
                $opt = $filter_set->opt_sensitive_email;
            }
        }

        // انجام عملیات متناسب با نتیجه
        switch ($opt) {
            case "waiting":
                $comment['status'] = 'waiting';
                $comments = $comment;
                break;
            case "abandon":
                $error = empty($error) ? "ارسال دیدگاه ناموفق بود" : $error;
                throw new Typecho_Widget_Exception(_t($error));
                break;
            default:
                break;
        }

        return $comments;
    }

    // بررسی وجود کلمات کلیدی در رشته
    public static function check_in($needles, $haystack)
    {
        $needles = explode("\n", $needles);
        foreach ($needles as $needle) {
            $needle = trim($needle);
            if ($needle != '' && strpos($haystack, $needle) !== false) {
                return true;
            }
        }
        return false;
    }
}