<?php
/**
 * پلاگین ارسال خودکار به بینگ ایندکس ناو
 * 
 * @package BingIndexNow
 * @author FluffyOx
 * @version 1.0.1
 * @link https://github.com/fluffyox/Typecho_BingIndexNow
 */
class BingIndexNow_Plugin implements Typecho_Plugin_Interface
{
    /**
     * فعال سازی پلاگین
     */
    public static function activate()
    {
        // ثبت تابع برای ارسال به بینگ هنگام انتشار مطلب
        Typecho_Plugin::factory('Widget_Contents_Post_Edit')->finishPublish = array('BingIndexNow_Plugin', 'submitToBingIndex');
        // ایجاد جدول پایگاه داده
        self::createDatabaseTable();
        // افزودن پنل تنظیمات
        Typecho_Plugin::factory('Widget_Plugins_Config')->register = array('BingIndexNow_Plugin', 'config');
        return _t('پلاگین با موفقیت فعال شد! برای اولین استفاده لطفا <a href="https://github.com/fluffyox/Typecho_BingIndexNow">راهنمای استفاده</a> را مطالعه کنید.');
    }

    /**
     * غیرفعال کردن پلاگین
     * 
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate() {
        // حذف جدول پایگاه داده
        self::deleteDatabaseTable();
    }

    /**
     * تنظیمات پلاگین
     */
    public static function config(Typecho_Widget_Helper_Form $form)
    {
        $apiKey = new Typecho_Widget_Helper_Form_Element_Text('apiKey', NULL, '', _t('کلید API بینگ'), 'آدرس دریافت: https://www.bing.com/webmasters/indexnow');
        $form->addInput($apiKey);

        $host = new Typecho_Widget_Helper_Form_Element_Text('host', NULL, '', _t('نام هاست'), 'مثال: www.example.com');
        $form->addInput($host);

        $keyLocation = new Typecho_Widget_Helper_Form_Element_Text('keyLocation', NULL, '', _t('محل ذخیره کلید'), 'مثال: https://www.example.com/0dcee520a4294f8eb5134f697c131a42.txt');
        $form->addInput($keyLocation);
    }

    public static function personalConfig(Typecho_Widget_Helper_Form $form) {}

    /**
     * ارسال مطلب به ایندکس بینگ
     */
    public static function submitToBingIndex($contents,$classa) 
    {
        // اگر مطلب خصوصی بود، ارسال نشود
        if('publish' != $contents['visibility']){
            return;
        }
        
        // دریافت تنظیمات پلاگین
        $options = Typecho_Widget::widget('Widget_Options');
        $apiKey = $options->plugin('BingIndexNow')->apiKey;
        $host = $options->plugin('BingIndexNow')->host;
        $keyLocation = $options->plugin('BingIndexNow')->keyLocation;
    
        // بررسی صحت تنظیمات
        if(empty($apiKey) || empty($host) || empty($keyLocation)) {
            return _t('تنظیمات پلاگین IndexNow بینگ ناقص است.');
        }

        // ساخت آدرس مطلب
        $parsedUrl = parse_url($keyLocation);
        $website = sprintf("%s://%s", $parsedUrl['scheme'], $parsedUrl['host']).'/index.php/archives/';
    
        // دریافت اطلاعات مطلب فعلی
        $post = Typecho_Widget::widget('Widget_Contents_Post_Edit');
        if(!$post->have()) {
            return _t('دریافت اطلاعات مطلب برای ارسال به بینگ ناموفق بود.');
        }

        $cid = $post->cid;
        $url = $website.$cid;
        $urlList = array($url);
    
        // آماده سازی داده‌های درخواست
        $requestData = array(
            'host' => $host,
            'key' => $apiKey,
            'keyLocation' => $keyLocation,
            'urlList' => $urlList
        );
    
        $jsonData = json_encode($requestData);
        if($jsonData === false) {
            return _t('تبدیل داده‌ها به فرمت JSON ناموفق بود.');
        }
    
        $headers = array(
            'Content-Type: application/json; charset=utf-8'
        );
    
        // ارسال درخواست به API بینگ
        $ch = curl_init('https://api.indexnow.org/IndexNow');
        if($ch === false) {
            return _t('خطا در آغاز ارتباط با cURL.');
        }
        
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        $msg = '';
        if(curl_errno($ch)) {
            $msg = 'ارسال به ایندکس بینگ ناموفق: '. curl_error($ch);
        } elseif($httpCode !== 200) {
            $msg = 'ارسال به ایندکس بینگ ناموفق. کد وضعیت HTTP: '. $httpCode;
        } else {
            $msg = 'مطلب با موفقیت به ایندکس بینگ ارسال شد';
        }
    
        curl_close($ch);
        
        // ثبت لاگ در پایگاه داده
        self::logToDatabase($post->cid, "داده‌های ارسالی: ".$jsonData." پاسخ: ".$response."; پیام: ".$msg, 
                          Typecho_Widget::widget('Widget_User')->uid, $_SERVER['REMOTE_ADDR']);
    }

    /**
     * ایجاد جدول پایگاه داده برای ذخیره لاگ‌ها
     */
    private static function createDatabaseTable()
    {
        try {
            $db = Typecho_Db::get();
            $prefix = $db->getPrefix();

            $sql = <<<SQL
CREATE TABLE IF NOT EXISTS {$prefix}bing_index_log (
    id INT AUTO_INCREMENT PRIMARY KEY,
    post_id INT,
    user_id INT,
    user_ip VARCHAR(255),
    response TEXT,
    timestamp INT
)
SQL;

            $db->query($sql);
        } catch(Exception $e) {
            echo 'خطا در عملیات پایگاه داده: ' . $e->getMessage();
        }
    }

    /**
     * حذف جدول پایگاه داده
     */
    private static function deleteDatabaseTable()
    {
        try {
            $db = Typecho_Db::get();
            $db->query("DROP TABLE `{$db->getPrefix()}bing_index_log`", Typecho_Db::WRITE);
        } catch(Exception $e) {
            echo 'خطا در عملیات پایگاه داده: ' . $e->getMessage();
        }
    }

    /**
     * ذخیره لاگ عملیات در پایگاه داده
     */
    private static function logToDatabase($postId, $response, $userId, $userIp)
    {
        try {
            $db = Typecho_Db::get();
            $prefix = $db->getPrefix();

            $log = array(
                'post_id' => $postId,
                'user_id' => $userId,
                'user_ip' => $userIp,
                'response' => $response,
                'timestamp' => time()
            );

            $db->query($db->insert($prefix . 'bing_index_log')->rows($log));
        } catch(Exception $e) {
            echo 'خطا در عملیات پایگاه داده: ' . $e->getMessage();
        }
    }
}