<?php
/**
 * یک پوسته زیبا که از وردپرس به Typecho تبدیل شده
 *
 * @package پوسته Lingonberry
 * @author liboy
 * @version 1.0
 * @link http://liboy.net
 */

$this->need('header.php');
?>
    <div class="content section-inner">


        <div class="posts">
            <?php while ($this->next()): ?>
            <div id="<?php $this->theId() ?>" class="<?php $this->theId() ?> post type-post status-publish format-standard">

                <div class="post-bubbles">

                    <a href="<?php $this->permalink() ?>" class="format-bubble"></a>

                </div>

                <div class="content-inner">
                    <div class="post-header">
                        <?php if($this->fields->featureUrl): ?>
                        <div class="featured-media">
                            <a href="<?php $this->permalink() ?>" rel="bookmark" title="<?php $this->title() ?>">
                                <img src="<?php $this->fields->featureUrl(); ?>" class="attachment-post-image" alt="<?php $this->title() ?>" />
                            </a>
                        </div>
                        <!-- /featured-media -->
                        <?php endif; ?>

                        <h2 class="post-title">
                            <a href="<?php $this->permalink() ?>" rel="bookmark" title="<?php $this->title() ?>">
                                <?php $this->title() ?>
                            </a>
                        </h2>

                        <div class="post-meta">

                            <span>
                                <a href="<?php $this->permalink() ?>" title="<?php $this->title() ?>">
                                    <?php
                                        if (function_exists('jalali_date')) {
                                            // تاریخ شمسی
                                            echo jalali_date('Y/m/d', (int)$this->created);
                                        } else {
                                            // تاریخ میلادی پیش‌فرض تایپچو
                                            $this->date();
                                        }
                                    ?>

                                </a>
                            </span>

                            <span class="date-sep"> / </span>

                            <span>
                                <?php $this->category(','); ?>
                            </span>

                            <span class="date-sep"> / </span>

                            <a href="<?php $this->permalink() ?>#comments" title="<?php $this->title() ?>">
                                <?php $this->commentsNum('0 دیدگاه', '1 دیدگاه', '%d دیدگاه'); ?>
                            </a>


                        </div>
                        <!-- /post-meta -->

                    </div>
                    <!-- /post-header -->

                    <div class="post-content">

                        <?php $this->excerpt(200, '...'); ?>

                        <p>
                            <a href="<?php $this->permalink() ?>" class="more-link">
                                <?php _e('[بیشتر بخوانید]'); ?>
                            </a>
                        </p>


                    </div>
                    <!-- /post-content -->

                    <div class="clear"></div>
                </div>
                <div class="clear"></div>

            </div>
            <!-- /post -->
            <?php endwhile; ?>
            <!-- /post -->
            <div class="post-nav archive-nav">

                <?php $this->pageNav('&laquo; صفحه قبلی', 'صفحه‌بعدی &raquo;'); ?>

                <div class="clear"></div>

            </div>
            <!-- /post-nav archive-nav -->

            <div class="clear"></div>


        </div>
        <!-- /posts -->

    </div>
    <!-- /content section-inner -->
    <?php $this->need('footer.php'); ?>