(() => {
    class OwO {
        constructor(option) {
            const defaultOption = {
                logo: 'OwO表情',
                container: document.getElementsByClassName('OwO')[0],
                target: document.getElementsByTagName('textarea')[0],
                position: 'down',
                width: '100%',
                maxHeight: '250px',
                api: '/usr/themes/PureSuck/js/OwO.json'
            };
            for (let defaultKey in defaultOption) {
                if (defaultOption.hasOwnProperty(defaultKey) && !option.hasOwnProperty(defaultKey)) {
                    option[defaultKey] = defaultOption[defaultKey];
                }
            }
            this.container = option.container;
            this.target = option.target;
            if (option.position === 'up') {
                this.container.classList.add('OwO-up');
            }

            const xhr = new XMLHttpRequest();
            xhr.onreadystatechange = () => {
                if (xhr.readyState === 4) {
                    if (xhr.status >= 200 && xhr.status < 300 || xhr.status === 304) {
                        this.odata = JSON.parse(xhr.responseText);
                        this.init(option);
                    } else {
                        console.log('OwO data request was unsuccessful: ' + xhr.status);
                    }
                }
            };
            xhr.open('get', option.api, true);
            xhr.send(null);
        }

        init(option) {
            this.area = option.target;
            this.packages = Object.keys(this.odata);

            let html = `
            <div class="OwO-logo"><span>${option.logo}</span></div>
            <div class="OwO-body" style="width: ${option.width}">`;

            this.packages.forEach(pkg => {
                const packageData = this.odata[pkg];
                const maxHeight = parseInt(option.maxHeight) - 53 + 'px';
                const packageWidth = packageData.width || ''; // Get width from package data

                html += `
                <ul class="OwO-items OwO-items-${packageData.type}" style="max-height: ${maxHeight};">`;

                packageData.container.forEach(item => {
                    const { text, input, icon } = item;
                    const isImage = packageData.type === 'image';
                    const imgWidth = packageWidth ? ` style="width: ${packageWidth};"` : ''; // Apply width to img tag
                    const inputValue = input || icon; // Use icon if input is not provided
                    html += `
                    <li class="OwO-item" title="${text}" data-input="${inputValue}">
                        ${isImage ? `<img src="${icon}" alt="${text}" loading="lazy"${imgWidth}>` : icon}
                    </li>`;
                });

                html += `
                </ul>`;
            });

            html += `
                <div class="OwO-bar">
                    <ul class="OwO-packages">`;

            this.packages.forEach(pkg => {
                html += `
                        <li><span>${pkg}</span></li>`;
            });

            html += `
                    </ul>
                    <div class="OwO-indicator"></div>
                </div>
            </div>`;

            this.container.innerHTML = html;

            this.logo = this.container.querySelector('.OwO-logo');
            this.logo.addEventListener('click', () => this.toggle());

            const body = this.container.querySelector('.OwO-body');
            body.addEventListener('click', (e) => {
                const target = e.target.closest('.OwO-item');
                if (target) {
                    const cursorPos = this.area.selectionEnd;
                    const textToInsert = target.getAttribute('data-input');
                    this.area.value = this.area.value.slice(0, cursorPos) + textToInsert + this.area.value.slice(cursorPos);
                    this.area.focus();
                    this.toggle();
                }
            });

            this.packagesEle = this.container.querySelector('.OwO-packages');
            this.packagesEle.addEventListener('click', (e) => {
                const target = e.target.closest('li');
                if (target) {
                    const index = Array.from(this.packagesEle.children).indexOf(target);
                    this.tab(index);
                }
            });

            this.tab(0);
        }

        toggle() {
            this.container.classList.toggle('OwO-open');
        }

        tab(index) {
            const itemsShow = this.container.querySelector('.OwO-items-show');
            if (itemsShow) itemsShow.classList.remove('OwO-items-show');
            this.container.querySelectorAll('.OwO-items')[index].classList.add('OwO-items-show');

            const packageActive = this.container.querySelector('.OwO-package-active');
            if (packageActive) packageActive.classList.remove('OwO-package-active');
            this.packagesEle.children[index].classList.add('OwO-package-active');

            const activeLink = this.packagesEle.children[index];
            const indicator = this.container.querySelector('.OwO-indicator');
            indicator.style.width = `${activeLink.offsetWidth}px`;
            indicator.style.left = `${activeLink.offsetLeft}px`;
        }
    }

    if (typeof module !== 'undefined' && typeof module.exports !== 'undefined') {
        module.exports = OwO;
    } else {
        window.OwO = OwO;
    }
})();

function initializeCommentsOwO() {
    const container = document.getElementsByClassName('OwO')[0];
    const target = document.getElementsByClassName('OwO-textarea')[0];
    if (container && target) {
        const OwO_demo = new OwO({
            logo: 'OωO表情',
            container,
            target,
            api: '/usr/themes/PureSuck/js/OwO.json',
            position: 'up',
            width: '100%',
            maxHeight: '260px'
        });

        const owoButton = document.getElementById('owo-button');
        if (owoButton) {
            owoButton.addEventListener('click', () => OwO_demo.toggle());
        }
    }
}

initializeCommentsOwO();