<?php if (!defined('__TYPECHO_ROOT_DIR__')) exit; ?>
<?php if ($this->allow('comment')): ?>
    <?php $this->header('commentReply=1&description=0&keywords=0&generator=0&template=0&pingback=0&xmlrpc=0&wlw=0&rss2=0&rss1=0&antiSpam=0&atom'); ?>

    <?php
    function threadedComments($comments, $options)
    {
        $cl = $comments->levels > 0 ? 'c_c' : 'c_p';
        $isAdmin = $comments->authorId == 1;
        $author = $comments->url ? '<a href="' . $comments->url . '" target="_blank" rel="external nofollow">' . $comments->author . '</a>' : $comments->author;
    ?>
        <li id="li-<?php $comments->theId(); ?>" class="<?= $cl; ?>">
            <div id="<?php $comments->theId(); ?>">
                <?php $avatarUrl = 'https://cn.cravatar.com/avatar/' . md5(strtolower($comments->mail)) . '?s=128&d=mm'; ?>
                <img class="avatarcc" src="<?= $avatarUrl; ?>" loading="lazy" alt="تصویر نویسنده" />
                <div class="cp">
                    <?= parseOwOcodes($comments->content); ?>
                    <div class="cm">
                        <span class="ca"><?= $author; ?></span>
                        <?php if ($isAdmin): ?>
                            <span class="badge">مدیر سایت</span>
                        <?php endif; ?>                      
                        <?php
                        if (function_exists('jalali_date')) {
                            echo jalali_date('H:i Y-m-d ', $comments->created);
                        } else {
                            $comments->date('Y-m-d H:i');
                        }
                        ?>

                        <span class="cr">
                            <?php $comments->reply(); ?>
                        </span>
                    </div>
                </div>
            </div>
            <?php if ($comments->children) { ?>
                <div class="children">
                    <?php $comments->threadedComments($options); ?>
                </div>
            <?php } ?>
        </li>
    <?php } ?>

    <div id="comments" class="cf">
        <?php $this->comments()->to($comments); ?>
        <?php if ($comments->have()): ?>
            <div class="comment-title">
                <?php $this->commentsNum(_t('دیدگاه'), _t('1 دیدگاه'), _t('%d دیدگاه')); ?>
            </div>
            <?php $comments->listComments(); ?>
            <div class="page-navigator">
                <?php $comments->pageNav('صفحه قبلی', 'صفحه بعدی', 10, '...', array('wrapTag' => 'ul', 'wrapClass' => 'pagination', 'itemTag' => 'li', 'currentClass' => 'active')); ?>
            </div>
        <?php endif; ?>
        <div id="<?php $this->respondId(); ?>" class="respond">
            <div class="ccr">
                <?php $comments->cancelReply(); ?>
            </div>
            <div class="response comment-title icon-chat">ثبت دیدگاه جدید</div>
            <form method="post" action="<?php $this->commentUrl() ?>" id="cf">
                <?php if ($this->user->hasLogin()): ?>
                    <span><a href="<?php $this->options->profileUrl(); ?>">
                            <?php $this->user->screenName(); ?> عزیز
                        </a>~ <a href="<?php $this->options->logoutUrl(); ?>" title="Logout">خروج &raquo;</a>
                    </span>
                <?php else: ?>
                    <?php if ($this->remember('author', true) != "" && $this->remember('mail', true) != ""): ?>
                        <span>
                            <?php $this->remember('author'); ?> خوش آمدی
                        </span>
                    <?php endif; ?>
                    <div class="ainfo">
                        <div class="tbox-container">
                            <div class="tbox">
                                <input type="text" name="author" id="author" class="ci" placeholder="نام شما" value="<?php $this->remember('author'); ?>" required="">
                            </div>
                            <div class="tbox">
                                <input type="email" name="mail" id="mail" class="ci" placeholder="آدرس ایمیل" value="<?php $this->remember('mail'); ?>" required="">
                            </div>
                            <div class="tbox">
                                <input type="url" name="url" id="url" class="ci" placeholder="آدرس وبسایت" value="<?php $this->remember('url'); ?>">
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="tbox">
                    <textarea name="text" id="textarea" class="ci OwO-textarea" placeholder="لطفاً متن دیدگاه خود را در این قسمت وارد کنید." required><?php $this->remember('text'); ?></textarea>
                    <div class="CtBoxBar">
                        <div class="left-bar">
                            <div class="OwO-bar">
                                <div class="OwO"></div>
                            </div>
                            <!-- 未来可以在这里添加更多内容 -->
                        </div>
                        <button type="submit" class="submit" id="submit">ارسال</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- CSS引入 -->
    <link rel="stylesheet" href="<?= $this->options->themeUrl('css/OwO.min.css'); ?>">

<?php else: ?>
    <div>
        <h3><?php _e('评论已关闭'); ?></h3>
        <div>
        <?php endif; ?>