<?php if (!defined('__TYPECHO_ROOT_DIR__')) exit; ?>
<?php
/**
 * 归档页面
 *
 * @package custom
 */
$this->need('header.php');
?>

<div class="wrapper">

    <?php
    $hasImg = $this->fields->img ? true : false;
    ?>
    <article class="post <?= $hasImg ? 'post--photo post--cover' : 'post--text'; ?> post--index main-item">
        <div class="post-inner" data-aos="fade-up" data-aos-anchor-placement="top-bottom">
            <header class="post-item post-header  <?= $hasImg ? 'no-bg' : ''; ?>">
                <div class="wrapper post-wrapper">
                    <div class="avatar post-author">
                        <img src="<?= $this->options->authorAvatar ?: $this->options->themeUrl('images/avatar.png'); ?>" alt="تصویر نویسنده" class="avatar-item avatar-img">
                        <span class="avatar-item">
                            <?php $this->author(); ?>
                        </span>
                    </div>
                </div>
            </header>

            <!-- 大图样式 -->
            <?php if ($hasImg): ?>
                <figure class="post-media <?= $this->is('post') ? 'single' : ''; ?>">
                    <img data-aos="zoom-out" data-aos-anchor-placement="top-bottom" itemprop="image" src="<?php $this->fields->img(); ?>" alt="تصویر سربرگ" width="2000" height="800">
                </figure>
            <?php endif; ?>

            <section class="post-item post-body">
                <div class="wrapper post-wrapper">
                    <h1 class="post-title">
                        <a href="<?php $this->permalink() ?>" title="<?php $this->title() ?>">
                            <?php $this->title() ?>
                        </a>
                    </h1>
                    <div class="inner-post-wrapper">

                        <div class="meta post-meta">
                            در اینجا همه مقالات ثبت و بایگانی میشوند.
در مجموع <?= getTotalPostsCount(); ?> مقاله نوشته شده که مجموعاً <?= allOfCharacters(); ?> کاراکتر دارند.
                        </div>

                        <!-- 标签 -->
                        <h2> برچسب </h2>
                        <section class="section-body">
                            <div class="cloud-container">
                                <?php $this->widget('Widget_Metas_Tag_Cloud')->to($tags); ?>
                                <?php if ($tags->have()): ?>
                                    <?php while ($tags->next()): ?>
                                        <a href="<?php $tags->permalink(); ?>" class="cloud-item"><?php $tags->name(); ?></a>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <p>هیچ برچسبی ثبت نشده است</p>
                                <?php endif; ?>
                            </div>
                        </section>

                        <h2>نمودار زمانی</h2>
                       <?php
                        // 获取所有文章
                        $this->widget('Widget_Contents_Post_Recent', 'pageSize=100')->to($posts);
                        $archives = [];

                        // 按年份和月份分组文章
                        while ($posts->next()) {
                            $date = $posts->date; // 获取文章日期
                            $timestamp = $date->getTimestamp(); // همیشه به یونیکس‌تایم دسترسی داریم

                            if (function_exists('jalali_date')) {
                                // پلاگین فعال است - تاریخ شمسی
                                $year = jalali_date('Y', $timestamp);
                                $monthDay = jalali_date('m-d', $timestamp);
                            } else {
                                // پلاگین غیرفعال - تاریخ میلادی معمول
                                $year = $date->format('Y');
                                $monthDay = $date->format('m-d');
                            }

                            $archives[$year][$monthDay][] = clone $posts; // 将文章添加到对应的年份和月份
                        }

                        // 输出归档
                        foreach ($archives as $year => $items) {
                            echo '<h3 class="timeline-year">' . $year . '</h3>'; // 输出年份
                            echo '<div id="timeline">'; // 开始时间线
                            foreach ($items as $monthDay => $posts) {
                                foreach ($posts as $item) {
                                    echo '<div class="timeline-item">';
                                    echo '<div class="timeline-dot"></div>';
                                    echo '<div class="timeline-content">';
                                    echo '<div class="timeline-date">' . $monthDay . '</div>'; // 只显示月和日
                                    echo '<div class="timeline-title"><a href="' . $item->permalink . '">' . $item->title . '</a></div>';
                                    echo '</div>'; // timeline-content
                                    echo '</div>'; // timeline-item
                                }
                            }
                            echo '</div>'; // 结束时间线
                        }
                        ?>

                    </div>
                </div>
            </section>

        </div>
    </article>

</div>

<nav class="nav main-pager" role="navigation" aria-label="Pagination" data-js="pager">
    <div class="nav main-lastinfo">
        <span class="nav-item-alt">
            <?php
            $options = Typecho_Widget::widget('Widget_Options');
            if (!empty($options->footerInfo)) {
                echo $options->footerInfo;
            }
            ?>
        </span>
    </div>
</nav>
</main>

<?php $this->need('sidebar.php'); ?>
<?php $this->need('footer.php'); ?>