<?php if (!defined('__TYPECHO_ROOT_DIR__')) exit; ?>
<?php $this->need('header.php'); ?>

<div class="wrapper">

    <h3 class="archive-title"><?php $this->archiveTitle([
                                    'category' => _t('分类 %s 下的文章'),
                                    'search'   => _t('包含关键字 %s 的文章'),
                                    'tag'      => _t('标签 %s 下的文章'),
                                    'author'   => _t('%s 发布的文章')
                                ], '', ''); ?></h3>

    <?php if ($this->have()): ?>
        <?php while ($this->next()): ?>
            <?php
            $hasImg = $this->fields->img ? true : false;
            ?>
            <article class="post <?= $hasImg ? 'post--photo post--cover' : 'post--text'; ?> post--index main-item">
                <div class="post-inner" data-aos="fade-up" data-aos-anchor-placement="top-bottom">
                    <header class="post-item post-header  <?= $hasImg ? 'no-bg' : ''; ?>">
                        <div class="wrapper post-wrapper">
                            <div class="avatar post-author">
                                <img src="<?= $this->options->authorAvatar ?: $this->options->themeUrl('images/avatar.png'); ?>" alt="تصویر نویسنده" class="avatar-item avatar-img">
                                <span class="avatar-item">
                                    <?php $this->author(); ?>
                                </span>
                            </div>
                        </div>
                    </header>

                    <!-- 大图样式 -->
                    <?php if ($hasImg): ?>
                        <figure class="post-media <?= $this->is('post') ? 'single' : ''; ?>">
                            <img data-aos="zoom-out" data-aos-anchor-placement="top-bottom" src="<?php $this->fields->img(); ?>" alt="تصویر سربرگ" width="2000" height="800">
                        </figure>
                    <?php endif; ?>

                    <section class="post-item post-body">
                        <div class="wrapper post-wrapper">
                            <h1 class="post-title">
                                <a href="<?php $this->permalink() ?>" title="<?php $this->title() ?>">
                                    <?php $this->title() ?>
                                </a>
                            </h1>
                            <p class="post-excerpt">
                                <?php if ($this->fields->desc): ?>
                                    <?= $this->fields->desc; ?>
                                <?php else: ?>
                                    <?php $this->excerpt(200, ''); ?>
                                <?php endif; ?>
                            </p>
                        </div>
                    </section>

                    <footer class="post-item post-footer">
                        <div class="wrapper post-wrapper">
                            <div class="meta post-meta">
                                <a itemprop="datePublished" href="<?php $this->permalink() ?>" class="icon-ui icon-ui-date meta-item meta-date">
                                    <span class="meta-count">
                                        <?php
                                        if (function_exists('jalali_date')) {
                                            // پلاگین فعال است → تاریخ شمسی با فرمت دلخواه
                                            echo jalali_date('Y-m-d', $this->created);
                                        } else {
                                            // پلاگین غیرفعال → تاریخ میلادی معمول قالب
                                            $this->date('Y-m-d');
                                        }
                                        ?>
                                    </span>
                                </a>
                                <a href="<?php $this->permalink() ?>#comments" class="icon-ui icon-ui-comment meta-item meta-comment">
                                    <?php $this->commentsNum('0 دیدگاه', '1 دیدگاه', '%d دیدگاه'); ?>
                                </a>
                            </div>
                        </div>
                    </footer>
                </div>
            </article>
        <?php endwhile; ?>
    <?php else: ?>
        <article class="post post--text post--index main-item" data-aos="fade-up" data-aos-anchor-placement="top-bottom">
            <div class="post-inner">
                <section class="post-item post-body" style="margin-top: 0px;">
                    <div class="wrapper post-wrapper">
                        <p style="text-align: center;">
                            <img src="<?php $this->options->themeUrl('images/Zai_Cry.png'); ?>" id="ZaiJPG" alt="نتیجه‌ای یافت نشد" style="display: block; margin: 0 auto;max-height: 200px;">
                        </p>
                        <p style="text-align: center;"><?php _e('متأسفم، هیچ نتیجه‌ای پیدا نکردم! (•́︿•̀ )'); ?></p>
                        <p style="text-align: center;"><?php _e('چرا کمی در سایت گشتی نمیزنی؟'); ?></p>
                    </div>

                </section>
            </div>
        </article>
    <?php endif; ?>

</div>

<nav class="nav main-pager" data-js="pager">
    <span class="nav-item-alt">
        صفحه <?php if ($this->_currentPage > 1) echo $this->_currentPage;
            else echo 1; ?>  / <?= ceil($this->getTotal() / $this->parameter->pageSize); ?> 
    </span>
    <div class="nav nav--pager">
        <?php $this->pageLink('قبلی', 'prev'); ?>
        <i class="icon-record-outline"></i>
        <?php $this->pageLink('بعدی', 'next'); ?>
    </div>
</nav>

<div class="nav main-lastinfo">
    <span class="nav-item-alt">
        <?php
        $options = Typecho_Widget::widget('Widget_Options');
        if (!empty($options->footerInfo)) {
            echo $options->footerInfo;
        }
        ?> </span>
</div>
</main>
<?php $this->need('sidebar.php'); ?>
<?php $this->need('footer.php'); ?>