# PureSuck-Theme (قالب پیرساک)

**PureSuck** یک قالب تایپچو تمیز، خالص و ساده با حال و هوایی لطیف و مینیمال است.

این اولین پروژه جدی من است و ممکن است مشکلات یا چالشهایی در آن باشد؛ خوشحال میشوم اگر باگ یا پیشنهادی داری به من اطلاع بدهی.
همچنین، رنگها و سبک کلی قالب همچنان در حال تغییر و بهروزرسانی است؛ پس ممکن است با هر آپدیت، برخی ظاهرها متفاوت شوند.
از اینکه از این قالب استفاده میکنی ممنونم!

## نمای ظاهری

برای مشاهده جدیدترین نمونه قالب، به [وبلاگ نمونه](https://note.moxiify.cn) برو.
قالب چهار رنگ تأکیدی مختلف دارد و همچنین چند ویجت رنگارنگ در آن تعبیه شده است (خوشحال میشوم پیشنهادات ویجت جدیدت را در Issues بنویسی).

## برنامههای آینده (TODO)

- [x] پشتیبانی از PJAX
- [ ] بازطراحی ویجتها
- [ ] سبکتر و عملکرد بهتر کدها
- [ ] یکپارچهسازی زبان طراحی


## ویژگیها

- **هایلایت کد**
- انیمیشنهای ظریف و جذاب
- **ظاهر بسیار مینیمال و تمیز**
- امکان سفارشیسازی تا حد مطلوب
- **تجربه مطالعه بسیار خوب**
- درخت فهرست مطالب (TOC)
- پشتیبانی از تصویر سربرگ
- **اجرای روان و سریع!**
- چند ویجت داخلی کاربردی
- ~~نویسنده هم آدم خوبی است و دوست دارد با شما گپ بزند!~~

برای جزئیات بیشتر کافیست خودت امتحان کنی 🙂

### نصب و راهاندازی

1. فایل قالب را با فرمت zip از [Releases گیتهاب](https://github.com/MoXiaoXi233/PureSuck-theme/releases) دانلود کن.
2. بعد از اکسترکت، پوشه را به مسیر قالب تایپچو منتقل کن.
3. **حتما نام پوشه را PureSuck قرار بده**؛ در غیر اینصورت ممکن است برخی قابلیتها یا استایلها اجرا نشود.
4. صفحه تنظیمات قالب را در مسیر: پنل مدیریت > کنترل پنل > ظاهر > تنظیمات قالب پیدا کن (راهنمای کامل تنظیمات داخل همان صفحه آمده).

پشتیبانی از افزونه [CommentNotifier](https://github.com/jrotty/CommentNotifier):
نام تابع بازگشتی باید "parseOwOcodes" باشد.

#### پیشنهادهای تکمیلی

- توصیه میشود در تنظیمات تایپچو «قابلیت مارکداون برای دیدگاهها» را فعال کنی.
- در بخش "تگهای HTML مجاز" حتماً تگهای زیر را در صورت نیاز اضافه کن:

```
<blockquote><pre><code><strong><em><h5><h6><a href title><table><thead><tr><th><tbody><td>
<ol><ul><li>
```

    - مثلاً برای امکان نقل قول باید `<blockquote>` اضافه باشد؛ برای بلوک کد، `<pre><code>` لازم است و الی آخر.
- برای تجربه بهتر با فونت چینی "霞骛文楷" استفاده کن (در صورت نیاز نصب کن).
- در صورت بروز مشکل میتوانید با نویسنده تماس بگیرید.


### قابلیتها و ویجتهای داخلی

**صفحه بایگانی:**
در پیشخوان تایپچو یک صفحه جدید بساز، نوع صفحه را "بایگانی" انتخاب کن.

**کدهای کوتاه (Shortcode) برای ویجتها و افکتها**

#### نوار هشدار رنگی

```
[alert type="red"]این یک هشدار قرمز است.[/alert]
[alert type="yellow"]این یک هشدار زرد است.[/alert]
[alert type="blue"]این یک هشدار آبی است.[/alert]
[alert type="green"]این یک هشدار سبز است.[/alert]
[alert type="pink"]این یک هشدار صورتی است.[/alert]
```

پنج رنگ مختلف پشتیبانی میشود (type را باید یکی از آنها بنویسی)؛ برای هشدار خاکستری فقط همان blockquote کافیست.

#### پنجرههای رنگی اطلاعات

```
[window type="red" title="عنوان پنجره"]متن داخل پنجره اطلاعات[/window]
[window type="yellow" title="هشدار"]اولین خط پیام<br>دومین خط پیام[/window]
```

پنج رنگ. فیلد title برای عنوان است و برای ایجاد خط جدید از تگ `<br>` استفاده کن.

#### کارت لینکهای دوستان

```
[friend-card name="دوست من" ico="avatar.jpg" url="http://example.com"]توضیح کوتاه درباره دوست[/friend-card]
```

رنگ کارت تابع رنگ تأکیدی قالب است و تغییر نمیکند.

#### پنل تاشونده (محتوای باز/بستهشونده)

```
[collapsible-panel title="عنوان پنل"]متن یا کد مورد نظر[/collapsible-panel]
```

رنگ خاکستری، مناسب برای نمایش متنهای بلند و کمتر استفادهشده.

#### تبهای چند منظوره

```
[tabs]
[tab title="درباره من"]متن درباره من[/tab]
[tab title="گروه چت"]آی‌دی گروه[/tab]
[tab title="دوستان"]لیست دوستان[/tab]
[tab title="درباره ما"]اطلاعات ما[/tab]
[/tabs]
```

ساده و قابل تو در تویی (به میزان مناسب).

#### تایملاین (خط زمانی)

```
[timeline]
[timeline-event date="2023-01-01" title="رویداد ۱"]توضیحات رویداد ۱[/timeline-event]
[timeline-event date="2023-02-01" title="رویداد ۲"]توضیحات رویداد ۲[/timeline-event]
[/timeline]
```

درون `[timeline]` میتوان به دفعات `[timeline-event]` تکرار کرد.

#### کارت ویدیو (فعلاً مخصوص Bilibili)

```
[bilibili-card bvid="BV1KJ411C7SB"]
```

کافی است این کد را درج کنی تا ویدیو در قالب کارت نمایش داده شود (پخش خودکار غیرفعال است).

### امکانات جدید در حال توسعه

#### گالری شبکهای عکس (پیکگرید)

```
[PicGrid]
![image.jpg][^1]
[/PicGrid]
```

چند عکس را داخل این تگها بذار تا همه بهصورت زیبای آبشاری نمایش داده شوند.

#### MoxDesign (ابزارهای JS آماده)

برای استفاده از اسکریپتهای MoxDesign در توسعه صفحات (مانند نوتیفیکیشن و Toast):

**نمونه نوتیفیکیشن:**

```
MoxNotification({
    title: "اعلان پایدار",
    message: "این نوتیفیکیشن به صورت خودکار بسته نمی‌شود.",
    duration: 0, // اگر صفر باشد باید دستی بسته شود
});
```

**نمونه Toast:**

```
MoxToast({
    message: "این یک پیام هشدار Toast است",
    duration: 3000,
    position: "bottom", // می‌تواند "top" یا "bottom" باشد
    backgroundColor: "var(--card2-color)",
    textColor: "var(--text-color)",
    borderColor: "var(--border-color)",
});
```

در حال توسعه ...

## استفاده از کتابخانههای خارجی

- [aos](https://github.com/michalsnik/aos)
- [medium-zoom](https://github.com/francoischalifour/medium-zoom)
- [OWO.JS](https://github.com/DIYgod/OwO)
- [HighLight.JS](https://github.com/highlightjs/highlight.js)
- [Pjax](https://github.com/MoOx/pjax)
- [Pace](https://github.com/CodeByZach/pace)


## لایسنس

کد منبع این قالب با مجوز MIT ارائه میشود و استفاده/توسعه/انتشار مجدد آزاد است.
از تکتک دوستانی که از این قالب استفاده میکنند صمیمانه تشکر میکنم!

**پیش به سوی یک وبسایت تمیز، سریع و شیک با تایپچو!**


