(function(){
  
  var inFlight = Object.create(null);
  var debounceMap = Object.create(null);

  function ensureOverlay() {
    var overlay = document.getElementById("ig-like-overlay");
    if (!overlay) {
      overlay = document.createElement("div");
      overlay.id = "ig-like-overlay";
      overlay.setAttribute("aria-hidden","true");
      overlay.innerHTML = '<div class="ig-heart"></div>';
      document.body.appendChild(overlay);
    }
    return overlay;
  }
  function showIGHeartEffect(durationMs) {
    var d = typeof durationMs === "number" ? durationMs : 1200;
    var overlay = ensureOverlay();
    overlay.classList.add("show");
    var heart = overlay.querySelector(".ig-heart");
    heart.style.animation = "none"; void heart.offsetWidth; heart.style.animation = "";
    setTimeout(function(){ overlay.classList.remove("show"); }, d);
  }

  
  function formatCount(n) {
    var x = Number(n) || 0;
    if (x >= 1e9) return (x/1e9).toFixed(x%1e9 ? 1 : 0).replace(/\.0$/,'') + "b";
    if (x >= 1e6) return (x/1e6).toFixed(x%1e6 ? 1 : 0).replace(/\.0$/,'') + "m";
    if (x >= 1e3) return (x/1e3).toFixed(x%1e3 ? 1 : 0).replace(/\.0$/,'') + "k";
    return String(x);
  }

  
  function showToast($btn, text) {
    var $ = window.jQuery;
    var $toast = $btn.find(".like-toast");
    if (!$toast.length) {
      $toast = $('<span class="like-toast" role="status" aria-live="polite"></span>');
      $btn.append($toast);
    }
    $toast.text(text);
    requestAnimationFrame(function(){
      $toast.addClass("show");
      setTimeout(function(){ $toast.removeClass("show"); }, 1100);
    });
  }

  function getLikedCids($) {
    try {
      if ($.macaroon) {
        var raw = $.macaroon("liked_cids") || "";
        return raw.split(",").map(function(s){ return s.trim(); }).filter(Boolean);
      }
    } catch(e){}
    return [];
  }
  function setLikedCids($, arr) {
    try {
      if ($.macaroon) {
        $.macaroon("liked_cids", arr.join(","), { expires: 365*24*60*60*1000, path: "/" });
      }
    } catch(e){}
  }

  function applyInitialLikedState($) {
    var likedCids = getLikedCids($);
    if (!likedCids.length) return;
    $(".like-btn").each(function(){
      var $btn = $(this);
      var cid = String($btn.data("post-id"));
      if (likedCids.indexOf(cid) !== -1) {
        $btn.addClass("liked").attr("aria-pressed","true");
      }
    });
  }

  
  function debounceClick($btn, wait) {
    var id = String($btn.data("post-id") || Math.random());
    var last = debounceMap[id] || 0;
    var now = Date.now();
    if (now - last < wait) return false;
    debounceMap[id] = now;
    return true;
  }

  function initLikeButtons($){
    
    applyInitialLikedState($);

    
    if (window.MutationObserver) {
      var obs = new MutationObserver(function(){
        applyInitialLikedState($);
      });
      obs.observe(document.body, { childList: true, subtree: true });
    }

    $(document).on("click", ".like-btn", function(e){
      e.preventDefault();
      var $btn = $(this);
      var cid = $btn.data("post-id");
      if (!cid) return;

      
      if (!debounceClick($btn, 220)) return;

      
      var key = String(cid);
      if (inFlight[key]) return;
      inFlight[key] = true;

      if ($btn.prop("disabled")) { inFlight[key] = false; return; }
      $btn.prop("disabled", true);

      var isLiked = $btn.hasClass("liked");
      var endpoint = isLiked ? "down" : "up";
      var base = (window.__LIKE_PLUGIN__ && window.__LIKE_PLUGIN__.base) ? window.__LIKE_PLUGIN__.base : "";

      
      $btn.addClass("is-animating");
      setTimeout(function(){ $btn.removeClass("is-animating"); }, 280);

      $.ajax({
        url: base + "/action/like?" + endpoint + "&cid=" + encodeURIComponent(cid),
        type: "POST",
        dataType: "json"
      }).done(function(res){
        
        if (res && typeof res.likes !== "undefined") {
          $btn.find(".like-count").text(formatCount(res.likes));
        }

        var likedCids = getLikedCids($);
        var sCid = String(cid);

        if (res && res.status === "success") {
          if (endpoint === "up" && res.liked) {
            $btn.addClass("liked").attr("aria-pressed","true");
            if (likedCids.indexOf(sCid) === -1) { likedCids.push(sCid); setLikedCids($, likedCids); }
            showIGHeartEffect(1200);
            showToast($btn, "Like");
          } else if (endpoint === "down" && !res.liked) {
            $btn.removeClass("liked").attr("aria-pressed","false");
            var idx = likedCids.indexOf(sCid);
            if (idx !== -1) { likedCids.splice(idx, 1); setLikedCids($, likedCids); }
            showToast($btn, "Unlike");
          }
        } else if (res && res.status === "repeat") {
          
          if (endpoint === "up") {
            $btn.addClass("liked").attr("aria-pressed","true");
            if (likedCids.indexOf(sCid) === -1) { likedCids.push(sCid); setLikedCids($, likedCids); }
            showToast($btn, "Already Liked");
          } else {
            $btn.removeClass("liked").attr("aria-pressed","false");
            var idx2 = likedCids.indexOf(sCid);
            if (idx2 !== -1) { likedCids.splice(idx2, 1); setLikedCids($, likedCids); }
            showToast($btn, "Already Unliked");
          }
        }
      }).fail(function(){
        
        showToast($btn, "Error!");
      }).always(function(){
        $btn.prop("disabled", false);
        inFlight[key] = false;
      });
    });
  }

  function boot() {
    if (window.jQuery) { initLikeButtons(window.jQuery); return; }
    var iv = setInterval(function(){
      if (window.jQuery) { clearInterval(iv); initLikeButtons(window.jQuery); }
    }, 50);
  }
  if (document.readyState === "loading") {
    document.addEventListener("DOMContentLoaded", boot);
  } else {
    boot();
  }
})();
