# Like Plugin for Typecho (SVG Heart + Toggle)

یک پلاگین لایک سبک برای Typecho با آیکن قلب SVG، ماندگاری حالت لایک، و امکان آنلایک.

## ویژگیها

- قلب SVG استاندارد: توخالی قبل از لایک، توپر بعد از لایک
- ماندگاری حالت لایک: هم در رندر سرور (SSR) بر اساس کوکی، هم در JS
- جلوگیری از لایک تکراری با کوکی liked_cids (path: "/")
- آنلایک (Toggle): کلیک دوباره لایک را کم میکند
- UX بهتر: افکت قلب اینستاگرامی، پالس روی دکمه، toast پیام، فرمت شمارنده 1.2k
- ایمن در برابر کلیکهای پیاپی و درخواستهای موازی
- **امکان دریافت جمع کل لایک‌های تمام پست‌ها**

## نصب

1) پوشه Like را در مسیر پلاگینهای Typecho قرار دهید.
2) در پیشخوان، پلاگین Like را فعال کنید (ستون likes به جدول contents افزوده میشود).
3) در تنظیمات پلاگین، در صورت نیاز بارگذاری خودکار jQuery را فعال کنید.

ساختار فایلها:

- Like/Plugin.php
- Like/Action.php
- Like/js/jquery.js
- Like/js/jquery.fs.macaroon.js
- Like/js/like.js
- Like/css/like.css

## استفاده در قالب

### دکمه لایک + شمارنده:
```php
<?php Like_Plugin::theLike(); ?>
```

### فقط عدد لایک پست فعلی:
```php
<?php Like_Plugin::theLike(false); ?>
```

### فهرست پرلایک‌ترین پست‌ها:
```php
<?php Like_Plugin::theMostLiked(10, true, '<li>', '</li>'); ?>
```

### دریافت جمع کل لایک‌های تمام پست‌ها:
```php
<?php 
if (class_exists('Like_Plugin')) {
    echo Like_Plugin::getTotalLikes();
}
?>
```

### نمایش جمع کل لایک‌ها با قالب‌بندی:
```php
<div class="stats-number">
    <?php 
    if (class_exists('Like_Plugin')) {
        echo number_format(Like_Plugin::getTotalLikes());
    }
    ?>
</div>
<div class="stats-label">Total Likes</div>
```

## تنظیم ظاهر

- اندازه آیکن: کلاس .heart-icon در CSS (پیشفرض 16px)
- رنگ قلب: color در .like-btn (پیشفرض #ff2d55)
- ضخامت خط توخالی: stroke-width مسیر heart-stroke (پیشفرض 1.6)

## تغییرات کلیدی نسبت به نسخه اصلی

- مهاجرت به SVG (توخالی/توپر) و حذف وابستگی به تصویر/فونت
- SSR liked بر پایه کوکی برای درستماندن حالت بعد از رفرش
- افزودن API down و toggle سمت کلاینت
- بهبود UX: افکت قلب، پالس، toast، فرمت شمارنده
- جلوگیری از کلیکهای پیاپی و درخواستهای موازی
- **افزودن تابع getTotalLikes() برای محاسبه مجموع لایک‌های کل سایت**

## نکات

- اگر نمایش خلاصه شمارنده (k/m/b) را نمیخواهید، فرمت در like.js را حذف کنید.
- برای غیرفعالکردن آنلایک، درخواست down را از JS بردارید.
- تابع getTotalLikes() فقط پست‌های منتشر شده (publish) را محاسبه می‌کند.
- همیشه با class_exists('Like_Plugin') از فعال بودن پلاگین اطمینان حاصل کنید.

مجوز: MIT 
