<?php
/**
 * Typecho Like plugin
 * 
 * @package Like
 * @author skylzl
 * @version 1.0.0
 * @link http://www.phoneshuo.com
 */

if (!defined('__TYPECHO_ROOT_DIR__')) exit;

class Like_Plugin implements Typecho_Plugin_Interface {

  public static function activate() {
    Helper::addAction('like', 'Like_Action');
    Typecho_Plugin::factory('Widget_Archive')->footer = array('Like_Plugin', 'footer');

    $db = Typecho_Db::get();
    $prefix = $db->getPrefix();
    $row = $db->fetchRow($db->select()->from('table.contents'));
    if (!array_key_exists('likes', $row)) {
      $db->query('ALTER TABLE `'. $prefix .'contents` ADD `likes` INT(10) DEFAULT 0;');
    }
  }

  public static function deactivate() {
    Helper::removeAction('like');
  }

  public static function config(Typecho_Widget_Helper_Form $form) {
    $likeClass = new Typecho_Widget_Helper_Form_Element_Text(
      'likeClass', NULL, 'post-like',
      _t('کلاس CSS دکمه لایک'),
      _t('مثلاً post-like (بدون نقطه).')
    );
    $jquery = new Typecho_Widget_Helper_Form_Element_Radio(
      'jquery', array('0' => 'بارگذاری دستی', '1' => 'بارگذاری خودکار'),
      0, 'jQuery', 'برای بارگذاری خودکار jQuery، گزینه مربوطه را انتخاب کنید.'
    );
    $form->addInput($jquery);
    $form->addInput($likeClass);
  }

  public static function personalConfig(Typecho_Widget_Helper_Form $form) {}

  // خروجی دکمه لایک با SVG
  // Like_Plugin::theLike(true) => دکمه + تعداد
  // Like_Plugin::theLike(false) => فقط عدد
  public static function theLike($link = true) {
    $db = Typecho_Db::get();
    $archive = Typecho_Widget::widget('Widget_Archive');
    $cid = $archive->cid;
    $row = $db->fetchRow(
      $db->select('likes')->from('table.contents')->where('cid = ?', $cid)
    );
    $count = isset($row['likes']) ? (int)$row['likes'] : 0;

    if (!$link) {
      echo $count;
      return;
    }

    
    $liked = false;
    if (!empty($_COOKIE['liked_cids'])) {
      $cookieRaw = str_replace(' ', '', $_COOKIE['liked_cids']);
      $arr = array_filter(explode(',', $cookieRaw), function($v){ return $v !== ''; });
      $liked = in_array((string)$cid, $arr, true);
    }

    $settings = Helper::options()->plugin('Like');
    $likeClass = !empty($settings->likeClass) ? $settings->likeClass : 'post-like';

    $btnClass = htmlspecialchars($likeClass) . ' like-btn' . ($liked ? ' liked' : '');
    $pressed = $liked ? 'true' : 'false';

    echo '<button class="'.$btnClass.'" data-post-id="'.$cid.'" aria-pressed="'.$pressed.'" title="لایک" type="button">'
       . '  <svg class="heart-icon" width="18" height="18" viewBox="0 0 24 24" aria-hidden="true" focusable="false">'
       . '    <path class="heart-stroke" fill="none" stroke="currentColor" stroke-width="2" stroke-linejoin="round"'
       . '      d="M12.1 8.64l-.1.1-.11-.11C10.14 6.9 7.1 6.91 5.36 8.65c-1.73 1.73-1.73 4.54 0 6.27l.11.11L12 21l6.53-5.97.11-.11c1.73-1.73 1.73-4.54 0-6.27-1.74-1.74-4.78-1.74-6.54 0z" />'
       . '    <path class="heart-fill" fill="currentColor"'
       . '      d="M12 21l-6.64-6.07c-2.02-1.84-2.13-5-.2-6.93 1.77-1.77 4.64-1.77 6.41 0l.43.43.43-.43c1.77-1.77 4.64-1.77 6.41 0 1.93 1.93 1.82 5.09-.2 6.93L12 21z"'
       . '      style="display:none" />'
       . '  </svg>'
       . '  <span class="like-count">'. $count .'</span>'
       . '</button>';
  }

  public static function theMostLiked($limit = 10, $showlink = true, $before = '<li>', $after = '</li>') {
    $db = Typecho_Db::get();
    $limit = is_numeric($limit) ? (int)$limit : 10;

    $posts = $db->fetchAll(
      $db->select()->from('table.contents')
         ->where('type = ? AND status = ? AND password IS NULL', 'post', 'publish')
         ->order('likes', Typecho_Db::SORT_DESC)
         ->limit($limit)
    );

    if ($posts) {
      foreach ($posts as $post) {
        $result = Typecho_Widget::widget('Widget_Abstract_Contents')->push($post);
        $post_likes = number_format((int)$result['likes']);
        $post_title = htmlspecialchars($result['title']);
        $permalink = $result['permalink'];

        if ($showlink) {
          echo $before . '<a href="'. $permalink .'">'. $post_title .'</a> (لایک: '. $post_likes .')' . $after;
        } else {
          echo $before . $post_title . ' (لایک: ' . $post_likes . ')' . $after;
        }
      }
    }
  }

  
  public static function getTotalLikes() {
    $db = Typecho_Db::get();
    
    $result = $db->fetchRow(
      $db->select('SUM(likes) as total_likes')
         ->from('table.contents')
         ->where('type = ? AND status = ?', 'post', 'publish')
    );
    
    return isset($result['total_likes']) ? (int)$result['total_likes'] : 0;
  }

  public static function footer() {
    $options = Helper::options();
    $settings = $options->plugin('Like');
    $pluginUrl = $options->pluginUrl . '/Like';
    $loadJq = !empty($settings->jquery) && $settings->jquery == 1;

    if ($loadJq) {
      echo '<script src="'. $pluginUrl .'/js/jquery.js"></script>';
    }
    echo '<script src="'. $pluginUrl .'/js/jquery.fs.macaroon.js"></script>';
    echo '<link rel="stylesheet" href="'. $pluginUrl .'/css/like.css">';
    echo '<script>
      window.__LIKE_PLUGIN__ = {
        base: "'. htmlspecialchars($options->index) .'",
        pluginUrl: "'. $pluginUrl .'"
      };
    </script>';
    echo '<script src="'. $pluginUrl .'/js/like.js"></script>';
  }
}
