<?php
if (!defined('__TYPECHO_ROOT_DIR__')) exit;

class Like_Action extends Typecho_Widget implements Widget_Interface_Do {

  private $db;

  public function __construct($request, $response, $params = NULL) {
    parent::__construct($request, $response, $params);
    $this->db = Typecho_Db::get();
  }

  public function action() {
    $this->on($this->request->is('up'))->up();
    $this->on($this->request->is('down'))->down();
    $this->response->goBack();
  }

  public function up() {
    $cid = $this->request->filter('int')->cid;
    if (!$cid) {
      return $this->response->throwJson(array('status' => 'error', 'message' => 'invalid cid'));
    }
    try {
      $row = $this->db->fetchRow(
        $this->db->select('likes')->from('table.contents')->where('cid = ?', $cid)
      );
      if (!$row) {
        return $this->response->throwJson(array('status' => 'error', 'message' => 'not found'));
      }

      $cookieName = 'liked_cids';
      $likedCids = array();
      if (isset($_COOKIE[$cookieName])) {
        $likedCids = array_values(array_filter(explode(',', str_replace(' ', '', $_COOKIE[$cookieName]))));
      }

      if (in_array((string)$cid, $likedCids, true)) {
       
        return $this->response->throwJson(array(
          'status' => 'repeat',
          'liked'  => true,
          'likes'  => (int)$row['likes']
        ));
      }

      $newLikes = ((int)$row['likes']) + 1;
      $this->db->query(
        $this->db->update('table.contents')->rows(array('likes' => $newLikes))->where('cid = ?', $cid)
      );

      
      $likedCids[] = (string)$cid;
      $cookieValue = implode(',', array_unique($likedCids));
      setcookie($cookieName, $cookieValue, time() + 365*24*60*60, '/');

      return $this->response->throwJson(array(
        'status' => 'success',
        'liked'  => true,
        'likes'  => $newLikes
      ));
    } catch (Exception $ex) {
      return $this->response->throwJson(array('status' => 'error', 'message' => $ex->getMessage()));
    }
  }

  public function down() {
    $cid = $this->request->filter('int')->cid;
    if (!$cid) {
      return $this->response->throwJson(array('status' => 'error', 'message' => 'invalid cid'));
    }
    try {
      $row = $this->db->fetchRow(
        $this->db->select('likes')->from('table.contents')->where('cid = ?', $cid)
      );
      if (!$row) {
        return $this->response->throwJson(array('status' => 'error', 'message' => 'not found'));
      }

      $cookieName = 'liked_cids';
      $likedCids = array();
      if (isset($_COOKIE[$cookieName])) {
        $likedCids = array_values(array_filter(explode(',', str_replace(' ', '', $_COOKIE[$cookieName]))));
      }

      if (!in_array((string)$cid, $likedCids, true)) {
        
        return $this->response->throwJson(array(
          'status' => 'repeat',
          'liked'  => false,
          'likes'  => (int)$row['likes']
        ));
      }

      $current = (int)$row['likes'];
      $newLikes = max(0, $current - 1);
      $this->db->query(
        $this->db->update('table.contents')->rows(array('likes' => $newLikes))->where('cid = ?', $cid)
      );

      
      $likedCids = array_values(array_filter($likedCids, function($v) use ($cid){ return $v !== (string)$cid; }));
      $cookieValue = implode(',', $likedCids);
      setcookie($cookieName, $cookieValue, time() + 365*24*60*60, '/');

      return $this->response->throwJson(array(
        'status' => 'success',
        'liked'  => false,
        'likes'  => $newLikes
      ));
    } catch (Exception $ex) {
      return $this->response->throwJson(array('status' => 'error', 'message' => $ex->getMessage()));
    }
  }
}
