<?php
/**
 * آمارگیر دقیق و حرفه‌ای برای تحلیل بازدید وب‌سایت و وبلاگ
 * @package Statfa
 * @author پوردریایی
 * @link https://pourdaryaei.ir/
 * @version 1.0
 * @description آمارگیر دقیق و حرفه‌ای برای تحلیل بازدید وب‌سایت و وبلاگ
 */
if (! defined('__TYPECHO_ROOT_DIR__')) {
    exit;
}

class StatsfaInjector_Plugin implements Typecho_Plugin_Interface
{
    // فعالسازی پلاگین و افزودن هوک‌ها
    public static function activate()
    {
        Typecho_Plugin::factory('Widget_Archive')->footer = ['StatsfaInjector_Plugin', 'injectScript'];
        return _t('پلاگین فعال شد!');
    }

    public static function deactivate()
    {return _t('پلاگین غیرفعال شد!');}
    public static function personalConfig(Typecho_Widget_Helper_Form $form)
    {}

    // فرم تنظیمات قسمت مدیر
    public static function config(Typecho_Widget_Helper_Form $form)
    {
        $script = new Typecho_Widget_Helper_Form_Element_Textarea(
            'custom_script',
            null,
            '',
            _t('کد اسکریپت سفارشی'),
            _t('کد اسکریپت آمارگیر یا هر کد دلخواه (مثال: اسکریپت statsfa.com) را اینجا قرار دهید. کد دقیقا قبل از </body> درج می‌شود.')
        );
        $form->addInput($script);
    }

    // درج اسکریپت در انتهای سایت
    public static function injectScript()
    {
        $options      = Helper::options();
        $customScript = isset($options->plugin('StatsfaInjector')->custom_script)
        ? trim($options->plugin('StatsfaInjector')->custom_script)
        : '';

        if (! empty($customScript)) {
            echo "\n<!-- StatsfaInjector Start -->\n";
            echo $customScript . "\n";
            echo "<!-- StatsfaInjector End -->\n";
        }
    }
}
