<?php
/**
 * پلاگین فونت‌های زیبای فارسی برای Typecho
 * 
 * @package FarsiFonts
 * @author پوردریایی
 * @version 1.0
 * @link https://pourdaryaei.ir
 */
class FontStoreFonts_Plugin implements Typecho_Plugin_Interface
{
    /**
     * فعال سازی پلاگین
     */
    public static function activate()
    {
        Typecho_Plugin::factory('Widget_Archive')->header = array('FontStoreFonts_Plugin', 'header');
        Typecho_Plugin::factory('Widget_Archive')->footer = array('FontStoreFonts_Plugin', 'footer');
        
        return _t('پلاگین فونت‌های فارسی با موفقیت فعال شد');
    }
    
    /**
     * غیرفعال سازی پلاگین
     */
    public static function deactivate()
    {
        return _t('پلاگین فونت‌های فارسی غیرفعال شد');
    }
    
    /**
     * پیکربندی پلاگین
     * 
     * @param Typecho_Widget_Helper_Form $form
     */
    public static function config(Typecho_Widget_Helper_Form $form)
    {
        // لیست فونت‌های تأیید شده
        $fonts = array(
            'shahab' => 'فونت شهاب',
            'behdad' => 'فونت بهداد',
            'nika' => 'فونت نیکا',
            'farbod' => 'فونت فربد',
            'noon' => 'فونت نون',
            'ganjnameh' => 'فونت گنجنامه',
            'yekan' => 'فونت یکان',
            'nazanin' => 'فونت نازنین'
        );
        
        $font = new Typecho_Widget_Helper_Form_Element_Select(
            'font',
            $fonts,
            'yekan',
            _t('فونت مورد نظر را انتخاب کنید'),
            _t('فونت انتخابی در کل سایت اعمال خواهد شد')
        );
        $form->addInput($font);
        
        $elements = new Typecho_Widget_Helper_Form_Element_Text(
            'elements',
            NULL,
            'body, h1, h2, h3, h4, h5, h6, .post-content',
            _t('عناصر HTML برای اعمال فونت'),
            _t('عناصری که می‌خواهید فونت روی آنها اعمال شود را با کاما جدا کنید')
        );
        $form->addInput($elements);
        
        $customCSS = new Typecho_Widget_Helper_Form_Element_Textarea(
            'custom_css',
            NULL,
            '',
            _t('CSS سفارشی'),
            _t('می‌توانید استایل‌های اضافه برای فونت وارد کنید')
        );
        $form->addInput($customCSS);
    }
    
    /**
     * رابط کاربری پیکربندی
     * 
     * @param Typecho_Widget_Helper_Form $form
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form) {}
    
    /**
     * اضافه کردن استایل به هدر
     */
    public static function header()
    {
        $options = Typecho_Widget::widget('Widget_Options')->plugin('FontStoreFonts');
        $font = $options->font;
        $cssUrl = "http://cdn.font-store.ir/{$font}.css";
        
        echo "<link rel='stylesheet' href='{$cssUrl}'>\n";
        echo "<style>\n";
        echo htmlspecialchars_decode($options->elements) . " {\n";
        echo "    font-family: '{$font}';\n";
        
        // اضافه کردن CSS سفارشی اگر وجود دارد
        if (!empty($options->custom_css)) {
            echo "\n" . htmlspecialchars_decode($options->custom_css) . "\n";
        }
        
        echo "}\n";
        echo "</style>\n";
    }
    
    /**
     * اضافه کردن اسکریپت به فوتر (اختیاری)
     */
    public static function footer()
    {
        // می‌توانید اسکریپت‌های اضافی را اینجا قرار دهید
    }
}