# JalaliDateHelper for Typecho

افزونه‌ای برای سیستم مدیریت محتوای [Typecho](https://typecho.org) که امکان تبدیل تاریخ میلادی به تاریخ شمسی (جلالی) را با پشتیبانی از نام ماه‌های فارسی در قالب فراهم می‌کند.

## ویژگی‌ها

- افزودن تابع کمکی `jalali_date` برای نمایش تاریخ شمسی در قالب‌ها
- پشتیبانی از نام ماه‌های فارسی
- بدون نیاز به تغییر در هسته یا پایگاه داده Typecho
- قابل استفاده در همه قالب‌ها پس از فعال‌سازی


## نصب

1. فایل پلاگین را با نام `JalaliDateHelper_Plugin.php` در پوشه `usr/plugins/` قرار دهید.
2. از بخش مدیریت Typecho، پلاگین را فعال کنید.

## نحوه استفاده

پس از فعال‌سازی، می‌توانید در قالب خود از تابع `jalali_date` استفاده کنید:

```

<?php echo jalali_date('Y/m/d H:i', $this->created); ?>

```

یا برای نمایش نام ماه فارسی:

```

<?php echo jalali_date('d F Y', $this->created); ?>

```


## فرمت‌های پشتیبانی‌شده

| حرف | توضیح |
| :-- | :-- |
| Y | سال شمسی |
| m | ماه شمسی (عدد) |
| d | روز ماه |
| F | نام ماه فارسی |
| H | ساعت (۲۴ ساعته) |
| i | دقیقه |
| s | ثانیه |

## مثال خروجی

```

<?php echo jalali_date('d F Y ساعت H:i', $this->created); ?>

```

خروجی نمونه:

```

۰۵ تیر ۱۴۰۴ ساعت ۱۳:۴۵

```


## لایسنس

این افزونه تحت مجوز MIT منتشر شده است.

## اطلاعیه مهم درباره پشتیبانی و گارانتی

این پلاگین به صورت رایگان و بدون هیچ گونه پشتیبانی رسمی یا گارانتی ارائه می‌شود.
استفاده، تغییر و توزیع آن کاملاً آزاد است و هرگونه مسئولیت ناشی از استفاده بر عهده کاربر می‌باشد.

از شما دعوت می‌کنیم با توجه به این شرایط، در صورت نیاز به تغییرات یا توسعه‌های بیشتر، خودتان یا تیم‌تان آن را سفارشی کنید.
