<?php
if (!defined('__TYPECHO_ROOT_DIR__')) exit;
/**
 * پلاگین آمار بازدید مقالات، با قابلیت تنظیم فاصله زمانی برای اینکه بازدیدهای مکرر از یک مقاله در شمارش بازدیدها لحاظ شود یا خیر.
 *
 * @package ViewsCounter
 * @author  Quarkay
 * @version 1.0.0
 * @link https://www.quarkay.com
 */
class ViewsCounter_Plugin implements Typecho_Plugin_Interface
{
    /**
     * متد فعال‌سازی پلاگین، در صورت شکست فعال‌سازی، یک استثنا (exception) پرتاب می‌شود
     *
     * @throws Typecho_Db_Exception
     */
    public static function activate()
    {
        Typecho_Plugin::factory('Widget_Archive')->beforeRender = array(
            'ViewsCounter_Plugin',
            'count'
        );

        // جدول contents را ویرایش کرده و فیلد views را اضافه می‌کند
        $db = Typecho_Db::get();
        $prefix = $db->getPrefix();
        if (!array_key_exists(
            'views',
            $db->fetchRow($db->select()->from('table.contents'))))
            $db->query(
                'ALTER TABLE `' . $prefix
                . 'contents` ADD `views` INT DEFAULT 0;'
            );
    }

    /**
     * متد غیرفعال‌سازی پلاگین، در صورت شکست غیرفعال‌سازی، یک استثنا (exception) پرتاب می‌شود
     *
     * @access public
     * @return void
     */
    public static function deactivate(){}

    /**
     * دریافت پنل تنظیمات پلاگین
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form پنل تنظیمات
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form){
//        $think_transaction = new Typecho_Widget_Helper_Form_Element_Radio(
//            'think_transaction', array(
//            '0' => 'همزمانی در نظر گرفته نشود',
//            '1' => 'همزمانی در نظر گرفته شود',
//        ), '0', 'تنظیمات آمار بازدید', 'در نظر گرفتن همزمانی بار بیشتری بر روی سیستم وارد می‌کند، اما نتایج آمار دقیق‌تر خواهد بود');
        $popular_limit = new Typecho_Widget_Helper_Form_Element_Text(
            'popular_limit',
            NULL,
            10,
            _t('تعداد مقالات نمایش داده شده در لیست پربازدیدترین‌ها')
        );
        $cookie_time = new Typecho_Widget_Helper_Form_Element_Text(
            'cookie_time',
            NULL,
            3600,
            _t('فاصله زمانی برای شمارش بازدیدهای مکرر از یک مقاله (به ثانیه)')
        );
//        $form->addInput($think_transaction);
        $form->addInput($popular_limit);
        $form->addInput($cookie_time);
    }

    /**
     * پنل تنظیمات برای کاربران شخصی
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}

    /**
     * اجرای فرآیند شمارش
     *
     * @access public
     * @param Widget_Archive $archive_obj
     * @return void
     * @throws  Typecho_Exception
     */
    public static function count($archive_obj)
    {
        // اگر کاربر وارد شده باشد (لاگین کرده باشد)، عملیات شمارش انجام نمی‌شود
        if (Typecho_Widget::widget('Widget_User')->hasLogin()) {
            return;
        }
        
        // شمارش فقط برای مقالات انجام می‌شود
        if ($archive_obj->is('single')) {
            $cid = $archive_obj->cid;
            $key = '__viewsCounter';
            $cids = Typecho_Cookie::get($key);
            $cookie_time = Typecho_Widget::widget('Widget_Options')
                    ->plugin('ViewsCounter')->cookie_time + 0;

            // شمارش فقط برای مقالاتی که به تازگی بازدید شده‌اند به‌روزرسانی می‌شود، در غیر این صورت بازگشته و هیچ عملیاتی انجام نمی‌شود
            if (!(is_null($cids) || !in_array("{$cid}", explode(',', $cids)))) {
                return;
            }

            $db = Typecho_Db::get();
            $row = $db->fetchRow(
                $db->select('views')->from('table.contents')
                    ->where('cid = ?', $cid)
            );

            // به دلیل محدودیت‌های لایه封装 دیتابیس در Typecho، این پلاگین فعلاً وضعیت همزمانی (concurrency) را در نظر نمی‌گیرد
            $db->query(
                $db->update('table.contents')->rows(
                    array('views' => (int)$row['views']+1)
                )
                    ->where('cid = ?', $cid)
            );
            $new_cids = is_null($cids) ? $cid :
                implode(',', array_merge(explode(',', $cids), [$cid]));

            // استفاده از کوکی برای ثبت
            Typecho_Cookie::set($key, $new_cids, time()+$cookie_time);
        }
    }

    /**
     * رابط (API) برای دریافت تعداد بازدید مقاله، با دریافت cid
     *
     * @access public
     * @return int
     * @throws
     */
    public static function getViewsById($cid)
    {
        $db = Typecho_Db::get();
        $row = $db->fetchRow(
            $db->select('views')->from('table.contents')->where('cid = ?', $cid)
        );
        return $row['views'];
    }

    /**
     * رابط (API) برای دریافت تعداد بازدید مقاله، جهت فراخوانی مستقیم در قالب
     *
     * @access public
     * @return int
     * @throws
     */
    public static function getViews()
    {
        return self::getViewsById(Typecho_Widget::widget('Widget_Archive')->cid);
    }

    /**
     * لیست محبوب‌ترین (پربازدیدترین) مقالات را به صورت آرایه باز می‌گرداند
     *
     * @return array
     * @throws
     */
    public static function getMostViewed()
    {
        $db = Typecho_Db::get();
        $limit = Typecho_Widget::widget('Widget_Options')
                ->plugin('ViewsCounter')->popular_limit + 0;
        $posts = $db->fetchAll(
            $db->select()->from('table.contents')->where(
                'type = ? AND status = ? AND password IS NULL',
                'post',
                'publish'
            )
                ->order('views', Typecho_Db::SORT_DESC)
                ->limit($limit)
        );
        // بسته‌بندی اطلاعات کامل‌تر برای ورودی
        $popular_list = [];
        foreach ($posts as $post) {
            $popular_list[] = Typecho_Widget::widget('Widget_Abstract_Contents')
                              ->push($post);
        }
        return $popular_list;
    }
}
