<?php
if (!defined('__TYPECHO_ROOT_DIR__')) exit;
function themeConfig($form) {
	Typecho_Widget::widget('Widget_Themes_List')->to($themes);

	


	$subtitle = new Typecho_Widget_Helper_Form_Element_Text('subtitle', NULL, '', _t('زیرعنوان سایت'), _t('زیرعنوان سایت را اینجا وارد کنید تا بعد از عنوان سایت نمایش داده شود'));
	$form->addInput($subtitle);
	$logoUrl = new Typecho_Widget_Helper_Form_Element_Text('logoUrl', NULL, '', _t('آدرس لوگوی سایت'), _t('اینجا آدرس URL یک تصویر را وارد کنید تا لوگو قبل از عنوان سایت نمایش داده شود'));
	$form->addInput($logoUrl);
	$avatarUrl = new Typecho_Widget_Helper_Form_Element_Text('avatarUrl', NULL, '', _t('آدرس تصویر پروفایل سایت'), _t('اینجا آدرس URL یک تصویر را وارد کنید تا در صفحه اصلی سایت تصویر پروفایل نمایش داده شود'));
	$form->addInput($avatarUrl);
	$indexImage = new Typecho_Widget_Helper_Form_Element_Text('indexImage', NULL, '', _t('آدرس تصویر پس‌زمینه صفحه اصلی'), _t('اینجا آدرس URL یک تصویر را وارد کنید تا به عنوان پس‌زمینه صفحه اصلی سایت تنظیم شود. اگر خالی باشد، پس‌زمینه گرادیان بنفش پیش‌فرض استفاده می‌شود'));
	$form->addInput($indexImage);
	$randomImage = new Typecho_Widget_Helper_Form_Element_Textarea('randomImage', NULL, '', _t('آدرس تصاویر پس‌زمینه تصادفی'), _t('اینجا یک یا چند آدرس URL تصویر را وارد کنید، هر خط یک آدرس. لطفاً کاراکتر اضافی وارد نکنید. این تصاویر به صورت تصادفی در صفحات مقالات، صفحات مستقل و سایر صفحات نمایش داده می‌شوند. اگر خالی باشد، پس‌زمینه گرادیان بنفش پیش‌فرض استفاده می‌شود'));
	$form->addInput($randomImage);
	$bubbleShow = new Typecho_Widget_Helper_Form_Element_Radio('bubbleShow', array('0' => _t('عدم نمایش'), '1' => _t('نمایش')), '1', _t('حباب‌های پس‌زمینه'), _t('انتخاب کنید که آیا حباب‌های نیمه‌شفاف در پس‌زمینه بالای صفحه اصلی و صفحات مقاله نمایش داده شوند یا خیر'));
	$form->addInput($bubbleShow);
	$footerText = new Typecho_Widget_Helper_Form_Element_Text('footerText', NULL, 'Powered by <a href="http://typecho.org/" class="footer-link">Typecho</a> | Theme by <a href="https://github.com/trinitrotofu/Bubble" class="footer-link">Bubble</a>', _t('متن پایین سمت چپ پاورقی'), _t('اینجا متن توضیحی پایین سمت چپ پاورقی را وارد کنید، مانند حق کپی‌رایت و اطلاعات مجوز، امکان افزودن تگ‌های HTML وجود دارد'));
	$form->addInput($footerText);
	$footerWidget = new Typecho_Widget_Helper_Form_Element_Radio('footerWidget', array('0' => _t('عدم نمایش'), '1' => _t('نمایش')), '1', _t('ابزارک‌های پاورقی'), _t('انتخاب کنید که آیا بخش‌هایی مانند «نظرات اخیر»، «آخرین مقالات» و غیره در پایین صفحه نمایش داده شوند یا خیر'));
	$form->addInput($footerWidget);
	$customCss = new Typecho_Widget_Helper_Form_Element_Textarea('customCss', NULL, '', _t('CSS سفارشی'), _t('اینجا CSS مورد نیاز را وارد کنید تا استایل صفحه را سفارشی کنید، مانند تنظیم اندازه فونت و غیره'));
	$form->addInput($customCss);
	$viewerEnable = new Typecho_Widget_Helper_Form_Element_Radio('viewerEnable', array('0' => _t('غیرفعال'), '1' => _t('فعال')), '1', _t('فعال‌سازی نمایشگر تصاویر viewer.js (برای بزرگنمایی کلیک کنید)'), _t('انتخاب کنید که آیا نمایشگر تصاویر viewer.js فعال شود یا خیر'));
	$form->addInput($viewerEnable);
	$Pjax = new Typecho_Widget_Helper_Form_Element_Radio('Pjax', array('0' => _t('غیرفعال'), '1' => _t('فعال')), '1', _t('فعال‌سازی حالت pjax سایت'), _t('انتخاب کنید که آیا حالت pjax سایت فعال شود تا تجربه کاربری بهبود یابد. توجه: فعال کردن این گزینه ممکن است باعث مشکلات بارگذاری صفحه شود، لطفاً مستندات پوسته را به دقت مطالعه کنید.'));
	$form->addInput($Pjax);
	$pjaxcomp = new Typecho_Widget_Helper_Form_Element_Textarea('pjaxcomp', NULL, '', _t('کد callback مربوط به pjax'), _t('اینجا کد JS را وارد کنید که پس از رندر شدن pjax باید اجرا شود. برای روش استفاده دقیق، مستندات پوسته را مطالعه کنید'));
	$form->addInput($pjaxcomp);
	$katex = new Typecho_Widget_Helper_Form_Element_Radio('katex', array('0' => _t('غیرفعال'), '1' => _t('فعال')), '0', _t('فعال‌سازی رندر فرمول‌های ریاضی katex'), _t('انتخاب کنید که آیا رندر فرمول‌های ریاضی katex فعال شود یا خیر'));
	$form->addInput($katex);
	$prismjs = new Typecho_Widget_Helper_Form_Element_Radio('prismjs', array('0' => _t('غیرفعال'), '1' => _t('فعال')), '0', _t('فعال‌سازی برجسته‌سازی کد prism.js'), _t('انتخاب کنید که آیا برجسته‌سازی کد prism.js فعال شود یا خیر'));
	$form->addInput($prismjs);
	$prismLine = new Typecho_Widget_Helper_Form_Element_Radio('prismLine', array('0' => _t('غیرفعال'), '1' => _t('فعال')), '0', _t('نمایش شماره خطوط prism.js'), _t('انتخاب کنید که شماره خطوط در سمت چپ برجسته‌سازی کد prism.js نمایش داده شود یا خیر'));
	$form->addInput($prismLine);
	$prismTheme = new Typecho_Widget_Helper_Form_Element_Select('prismTheme',
		array('prism' => _t('پیش‌فرض'),
			'prism-coy' => _t('Coy'),
			'prism-dark' => _t('Dark'),
			'prism-funky' => _t('Funky'),
			'prism-okaidia' => _t('Okaidia'),
			'prism-solarizedlight' => _t('Solarizedlight'),
			'prism-tomorrow' => _t('Tomorrow'),
			'prism-twilight' => _t('Twilight')
		),
	'prism', _t('تم رنگی برجسته‌سازی prism.js'), _t('انتخاب رنگ تم برای برجسته‌سازی کد prism.js'));
	$form->addInput($prismTheme);
	$toc = new Typecho_Widget_Helper_Form_Element_Radio('toc',
		array('0' => _t('غیرفعال'),
			'1' => _t('فعال'),
		),
		'1', _t('فعال‌سازی فهرست مطالب (TOC) مقاله'), _t('انتخاب کنید که آیا فهرست مطالب مقاله فعال شود یا خیر'));
	$form->addInput($toc);
	$toc_enable = new Typecho_Widget_Helper_Form_Element_Radio('toc_enable',
		array('0' => _t('غیرفعال'),
			'1' => _t('فعال'),
		),
		'0', _t('وضعیت پیش‌فرض باز بودن فهرست مطالب'), _t('انتخاب کنید که هنگام باز کردن مقاله، فهرست مطالب باز باشد یا خیر'));
	$form->addInput($toc_enable);
	$comment_indent_style = new Typecho_Widget_Helper_Form_Element_Radio('comment_indent_style',
		array('native' => _t('سبک Typecho'),
			'bubble' => _t('سبک Bubble'),
		),
		'bubble', _t('سبک تورفتگی نظرات'), _t('انتخاب سبک تورفتگی نظرات: سبک Typecho برای هر لایه پاسخ تورفتگی می‌دهد، سبک Bubble نظرات را در صورت نیاز در یک لایه ترکیب می‌کند تا خواندن آسان‌تر شود'));
	$form->addInput($comment_indent_style);
	$comment_object_nick = new Typecho_Widget_Helper_Form_Element_Radio('comment_object_nick',
		array('0' => _t('عدم نمایش'),
			'1' => _t('نمایش'),
		),
		'1', _t('نمایش نام کاربری فرد پاسخ داده شده'), _t('انتخاب کنید که آیا نام کاربری فرد پاسخ داده شده نمایش داده شود، به صورت «aa پاسخ به bb» یا فقط «aa»'));
	$form->addInput($comment_object_nick);

	$header_links_html = '
	<style>
		input[name=headerLinks]{
			display:none;
		}
	</style>
	<script>
	$(document).ready(function(){
		var editTemplate = \'<li class="size-5"><input type="checkbox"><span rel="$Link$">$Name$</span><a class="tag-edit-link linkEditer"><i class="i-edit"></i></a><a class="tag-edit-link linkDeleter"><i class="i-delete"></i></a></li>\'
		var finalTextform = $("input[name=headerLinks]")
		var linkList = finalTextform.val().split("$@!$")
		var isInEditing = -1
		var editTag = (is) => {
			isInEditing = is
			if(isInEditing == -1){
				$("#linkTagAddButton").text("افزودن")
				$("#linkTagCancleButton").hide()
			}else{
				$("#linkTagAddButton").text("ویرایش")
				$("#linkTagCancleButton").show()
			}
			
		}

		var updateList = () => {
			var renderedHtml = ""
			for (var eachLink in linkList){
				link = linkList[eachLink].split("$$")
				renderedHtml += editTemplate.replace("$Name$", link[0]).replace("$Link$", link[1])
			}
			$("#linkTags").html(renderedHtml)

			$(".linkEditer").click(function (){
				var span = $(this).prev()
				$("#linkTagAddLink").val(span.attr("rel"))
				$("#linkTagAddName").val(span.text())
				editTag(linkList.indexOf(span.text() + "$$" + span.attr("rel")))
			})
			$(".linkDeleter").click(function (){
				var span = $(this).prev().prev()
				linkList.splice(linkList.indexOf(span.text() + "$$" + span.attr("rel")), 1)
				updateList()
				updateForm()
			})
		}
		var updateForm = () => {
			finalTextform.val(linkList.join("$@!$"))
		}

		var clear = () => {
			$("#linkTagAddLink").val("")
			$("#linkTagAddName").val("")
		}
		updateList()
		
		$("#linkTagAddButton").click(() => {
			var link = $("#linkTagAddName").val() + "$$" + $("#linkTagAddLink").val()
			if(isInEditing == -1){
				if($("#linkTagAddName").val() != "" && $("#linkTagAddLink").val() != ""){
					linkList.push(link)
				}
			}else{
				linkList[isInEditing] = link
				editTag(-1)
			}
			updateList()
			updateForm()
			clear()
		})

		$("#linkTagCancleButton").click(() => {
			editTag(-1)
			clear()
		})
	})
	</script>
	</p>

		<ul class="typecho-list-notable tag-list clearfix" id="linkTags">
		</ul>
		<p class="description"></p>
		<div class="row">
			<div class="col-mb-12 col-tb-4">
				<label class="typecho-label">نام لینک</label>
				<input id="linkTagAddName" type="text" class="text" value="">
			</div>
			<div class="col-mb-12 col-tb-4">
				<label class="typecho-label">آدرس لینک</label>
				<input id="linkTagAddLink" type="text" class="text" value="">
			</div>
			<div class="col-mb-12 col-tb-3">
				<label class="typecho-label"> &nbsp;</label>
				<button type="button" class="btn primary" id="linkTagAddButton">افزودن</button>
				<button type="button" class="btn" id="linkTagCancleButton" style="display: none;">لغو</button>
			</div>
		</div>
	
	<p class="description">ویرایش لینک‌های نمایش داده شده در بالای صفحه';
	$headerLinks = new Typecho_Widget_Helper_Form_Element_Text('headerLinks', NULL, '', _t('لینک‌های بالای صفحه'), $header_links_html);
	$form->addInput($headerLinks);
}

function printCategory($that, $icon = 0) { ?>
	<span class="list-tag">
		<?php if ($icon) { ?><i class="fa fa-folder-o" aria-hidden="true"></i><?php } ?>
		<?php foreach( $that->categories as $categories): ?>
		<a href="<?php print($categories['permalink']) ?>" class="badge badge-info badge-pill"><?php print($categories['name']) ?></a>
		<?php endforeach;?>
	</span>
<?php }

function printTag($that, $icon = 0) { ?>
	<span class="list-tag">
		<?php if ($icon) { ?><i class="fa fa-tags" aria-hidden="true"></i><?php } ?>
		<?php if (count($that->tags) > 0): ?>
			<?php foreach( $that->tags as $tags): ?>
			<a href="<?php print($tags['permalink']) ?>" class="badge badge-success badge-pill"><?php print($tags['name']) ?></a>
			<?php endforeach;?>
		<?php else: ?>
			<a class="badge badge-default badge-pill text-white">ندارد</a>
		<?php endif;?>
	</span>
<?php }

function printAricle($that, $flag) { ?>
<?php if($that->fields->pic){ ?>
    
    <a class="card shadow content-card list-image-card <?php if ($flag): ?>content-card-head<?php endif; ?>" href="<?php $that->permalink() ?>">
        <div class="list-card-bg" data-src="<?php echo $that->fields->pic ?>"></div>
		<object class="list-image-card-section">
			<div class="container">
				<div class="content list-card-content">
					<h1><?php $that->title() ?></h1>
					<div class="list-object">
						<span class="list-tag"><i class="fa fa-calendar-o" aria-hidden="true"></i>
							 <time datetime="<?php $that->date('c'); ?>">
							    <?php if (function_exists('jalali_date')): ?>
							        <?php echo jalali_date('Y/m/d', $that->created); ?>
							    <?php else: ?>
							        <?php $that->date('Y/m/d'); ?>
							    <?php endif; ?>
							</time>
						</span>
						<span class="list-tag"><i class="fa fa-comments-o" aria-hidden="true"></i> <?php $that->commentsNum('%d');?> دیدگاه</span>
						<?php printCategory($that, 1); ?>
						<?php printTag($that, 1); ?>
						<span class="list-tag"><i class="fa fa-user-o" aria-hidden="true"></i> <a class="badge badge-warning badge-pill" href="<?php $that->author->permalink(); ?>"><?php $that->author();?></a></span>
					</div>
					<?php $that->excerpt(200,'...'); ?>
				</div>
			</div>
		</object>
	</a>
<?php }else{ ?>
	<a class="card shadow content-card list-card <?php if ($flag): ?>content-card-head<?php endif; ?>" href="<?php $that->permalink() ?>">
		<object class="section">
			<div class="container">
				<div class="content list-card-content">
					<h1><?php $that->title() ?></h1>
					<div class="list-object">
						<span class="list-tag"><i class="fa fa-calendar-o" aria-hidden="true"></i> 
							<time datetime="<?php $that->date('c'); ?>">
							    <?php 
							    if (function_exists('jalali_date')) {
							        echo jalali_date('Y/m/d', $that->created);
							    } else {
							        $that->date('Y/m/d'); 
							    }
							    ?>
							</time>
						</span>
						<span class="list-tag"><i class="fa fa-comments-o" aria-hidden="true"></i> <?php $that->commentsNum('%d');?> دیدگاه</span>
						<?php printCategory($that, 1); ?>
						<?php printTag($that, 1); ?>
						<span class="list-tag"><i class="fa fa-user-o" aria-hidden="true"></i> <a class="badge badge-warning badge-pill" href="<?php $that->author->permalink(); ?>"><?php $that->author();?></a></span>
					</div>
					<?php $that->excerpt(200,'...'); ?>
				</div>
			</div>
		</object>
	</a>
	<?php } ?>
<?php }

function printToggleButton($that) {
	if ($that->getTotal() > $that->parameter->pageSize) { ?>
		<section class="section" style="padding-bottom: 1rem; padding-top: 6rem">
			<div class="container">
				<nav class="page-nav"><?php $that->pageNav('<i class="fa fa-angle-right" aria-hidden="true"></i>', '<i class="fa fa-angle-left" aria-hidden="true"></i>', 1, '...', array('wrapTag' => 'ul', 'wrapClass' => 'pagination justify-content-center', 'textTag' => 'a', 'currentClass' => 'active', 'prevClass' => '', 'nextClass' => '')); ?></nav>
			</div>
		</section>
	<?php }
}

function printBackground($url, $show) {
	_e('<div ');
	if ($url == '') _e('class="shape shape-style-1 shape-primary"');
	else _e('class="shape shape-style-1 shape-image" style="background-image: url(' . "$url" . ')"');
	_e('>');
	if ($show)
		_e('<span class="span-150"></span>
			<span class="span-50"></span>
			<span class="span-50"></span>
			<span class="span-75"></span>
			<span class="span-100"></span>
			<span class="span-75"></span>
			<span class="span-50"></span>
			<span class="span-100"></span>
			<span class="span-50"></span>
			<span class="span-100"></span>');
	_e('</div>');
}

function getRandomImage($str)
{
	if ($str == '') return '';
	$arr = explode(PHP_EOL, $str);
	return $arr[rand(0, sizeof($arr) - 1)];
}

function clear_urlcan($url)
{
	$rstr='';
	$tmparr=parse_url($url);
	$rstr=empty($tmparr['scheme'])?'http://':$tmparr['scheme'].'://';
	$rstr.=$tmparr['host'].$tmparr['path'];
	return $rstr;
}

function createCatalog($obj) {
	global $catalog;
	global $catalog_count;
	$catalog = array();
	$catalog_count = 0;
	$obj = preg_replace_callback('/<h([1-6])(.*?)>(.*?)<\/h\1>/i', function($obj) {
		global $catalog;
		global $catalog_count;
		$catalog_count ++;
		$catalog[] = array('text' => trim(strip_tags($obj[3])), 'depth' => $obj[1], 'count' => $catalog_count);
		return '<h'.$obj[1].$obj[2].'><a name="cl-'.$catalog_count.'"></a>'.$obj[3].'</h'.$obj[1].'>';
	}, $obj);
	return $obj;
}

function getCatalog() {
	global $catalog;
	$index = '';
	if ($catalog) {
		$index = '<ul>'."\n";
		$prev_depth = '';
		$to_depth = 0;
		foreach($catalog as $catalog_item) {
			$catalog_depth = $catalog_item['depth'];
			if ($prev_depth) {
				if ($catalog_depth == $prev_depth) {
					$index .= '</li>'."\n";
				} elseif ($catalog_depth > $prev_depth) {
					$to_depth++;
					$index .= '<ul>'."\n";
				} else {
					$to_depth2 = ($to_depth > ($prev_depth - $catalog_depth)) ? ($prev_depth - $catalog_depth) : $to_depth;
					if ($to_depth2) {
						for ($i=0; $i<$to_depth2; $i++) {
							$index .= '</li>'."\n".'</ul>'."\n";
							$to_depth--;
						}
					}
					$index .= '</li>';
				}
			}
			$index .= '<li><a name="dl-' . $catalog_item['count'] . '" href="javascript:jumpto('.$catalog_item['count'].')">'.$catalog_item['text'].'</a>';
			$prev_depth = $catalog_item['depth'];
		}
		for ($i=0; $i<=$to_depth; $i++) {
			$index .= '</li>'."\n".'</ul>'."\n";
		}
	}
	echo $index;
}

function getCommentLineInDb($coid, $depth=3) { // 3 for getting this comment, the parent and the grandparent by default
	$db = Typecho_Db::get();
	$commentLine = [];
	while((count($commentLine) < $depth) and (isset($coid) and 0 != $coid)) {
		$row = $db->fetchRow($db->select()->from('table.comments')->where('coid = ? ', $coid));
		if(empty($row)) break;
		array_push($commentLine, $row);
		$coid = $row['parent'];
	}
	return $commentLine;
}

function shouldCommentIndent($comment, &$comment_line=NULL) {
	$commentIndentStyle = Helper::options()->comment_indent_style;
	$commentLine = getCommentLineInDb($comment->coid);
	$isTopLevel = count($commentLine) == 1;
	$thisAuthor = $comment->author;
	$parentAuthor = count($commentLine) >= 2? $commentLine[1]['author']:NULL;
	$grandparentAuthor = count($commentLine) >= 3? $commentLine[2]['author']:NULL;
	$indent = false;
	if($commentIndentStyle==NULL || $commentIndentStyle=='bubble') {
		$indent = !$isTopLevel; // پاسخ‌های سطح اول نیاز به تورفتگی ندارند، پاسخ‌های غیر سطح اول تورفتگی دارند
		// اگر والد و پدربزرگ نظر وجود داشته باشد
		if($parentAuthor && $grandparentAuthor) {
			// اگر نویسنده نظر فعلی همان نویسنده والد یا پدربزرگ باشد، تورفتگی ندارد
			$indent &= !($thisAuthor == $parentAuthor || $thisAuthor == $grandparentAuthor);
		}
	} else {
		$indent = true;
	}
	if($comment_line!==NULL) {
		$comment_line = $commentLine;
	}
	return $indent;
}

function themeInit($archive) {

}

function themeFields($layout) {
    $logoUrl = new Typecho_Widget_Helper_Form_Element_Text('pic', NULL, NULL, _t('آدرس تصویر سربرگ مقاله'), _t('اینجا آدرس URL یک تصویر را وارد کنید تا مقاله دارای تصویر سربرگ باشد'));
    $layout->addItem($logoUrl);
}
