## پوسته Bubble

قالبی با سبک تازه و واکنش‌گرا برای Typecho.

سادگی در عین زیبایی، مانند نسیمی تازه.

دمو: [https://typecho.tntofu.com/](https://typecho.tntofu.com/)

اگر این پوسته را دوست داشتید، لطفاً یک ستاره بدهید؛ این بهترین تشویق برای توسعه‌دهندگان پوسته‌های متن‌باز است.

### ویژگی‌ها

+ **رابط کاربری تازه:** صفحه‌ای با طراحی ساده و جذاب مبتنی بر Argon Design System، با فاصله‌بندی مناسب عناصر  
+ **طراحی کاربرپسند:** نمایش دکمه مدیریت پس از ورود، متن‌های برجسته، چینش دکمه‌ها برای سهولت استفاده و واکنش‌گرایی صفحات  
+ **تجربه کاربری روان:** پشتیبانی از PJAX در کل سایت، کامنت‌گذاری بدون رفرش با AJAX، بارگذاری اکثر فایل‌های استاتیک پوسته از CDN جهانی jsDelivr برای کاهش فشار روی سرور  
+ **کدهای کوتاه:** استفاده از تگ‌های HTML خاص پوسته برای امکانات بیشتر مانند کادرهای کد برجسته و کارت‌های لینک دوستان  
+ **پس‌زمینه سفارشی:** تصویر پس‌زمینه ثابت برای صفحه اصلی و تصاویر پس‌زمینه تصادفی برای صفحات دیگر، برای نمایش سلیقه شخصی  
+ **برجسته‌سازی کد:** استفاده از prism.js برای هایلایت کد با تم‌های متنوع و پردازش سریع  
+ **فرمول‌های ریاضی:** رندر فرمول‌های ریاضی با KaTeX که سبک‌تر و سریع‌تر از MathJax است  
+ **استایل سفارشی:** امکان افزودن CSS توسط کاربر برای تغییر ظاهر پوسته  
+ **حجم کم فایل:** بسته نصب پوسته کمتر از ۲۵۰ کیلوبایت پس از حذف پوشه .git، ساده اما حرفه‌ای  

~~واقعا به توانایی خودم در نوشتن متن تبلیغاتی افتخار می‌کنم.~~

### نصب

فایل zip پوسته را از بخش [Releases](https://github.com/trinitrotofu/Bubble/releases) دانلود و پس از استخراج، در پوشه پوسته‌های Typecho قرار دهید.

### تنظیمات

مسیر صفحه تنظیمات پوسته: پنل مدیریت Typecho -> کنترل پنل -> ظاهر -> تنظیمات ظاهر.

### به‌روزرسانی

پوسته قابلیت بررسی خودکار به‌روزرسانی و نصب با یک کلیک را دارد.  
دکمه به‌روزرسانی خودکار در صفحه تنظیمات پوسته قرار دارد.  
نسخه جدید پوسته از CDN jsDelivr دانلود و جایگزین نسخه قدیمی می‌شود.  
همچنین می‌توانید به صورت دستی نسخه قدیمی را حذف و نسخه جدید را نصب کنید.  
توجه: پس از به‌روزرسانی ممکن است گزینه‌های جدیدی اضافه شود که اگر پوسته را غیرفعال و دوباره فعال نکنید، ممکن است باعث بروز اشکال شود. پس حتما پس از به‌روزرسانی پوسته را ریستارت کنید یا تنظیمات را بررسی نمایید.

### توضیح گزینه‌های مهم تنظیمات

- **زیرعنوان سایت:** متن نمایش داده شده پس از عنوان سایت در صفحه اصلی  
- **لوگوی سایت:** آدرس URL تصویری که در کنار عنوان تب مرورگر نمایش داده می‌شود (آدرس نسبی نباشد)  
- **آواتار سایت:** آدرس URL تصویری که بالای عنوان اصلی صفحه اول نمایش داده می‌شود (آدرس نسبی نباشد)  
- **تصویر پس‌زمینه صفحه اصلی:** URL تصویر پس‌زمینه صفحه اصلی، اگر خالی باشد پس‌زمینه پیش‌فرض گرادیان بنفش نمایش داده می‌شود  
- **آدرس تصاویر پس‌زمینه تصادفی:** یک یا چند URL تصویر برای پس‌زمینه صفحات مقاله و صفحات دیگر؛ هر URL در یک خط و بدون کاراکتر اضافه، به صورت تصادفی انتخاب می‌شود  
- **حباب‌های پس‌زمینه:** فعال یا غیرفعال کردن نمایش حباب‌های نیمه‌شفاف در بالای پس‌زمینه صفحه اصلی و صفحات مقاله  
- **متن پایین سمت چپ فوتر:** متن توضیحاتی مانند کپی‌رایت یا اطلاعات ثبت  
- **ابزارک‌های فوتر:** نمایش یا عدم نمایش بخش‌هایی مانند «جدیدترین نظرات»، «جدیدترین مقالات» و «آرشیو اخیر» در پایین صفحه  
- **CSS سفارشی:** امکان وارد کردن کدهای CSS برای تغییر ظاهر پوسته بدون نیاز به پاک کردن کش  
- **حالت PJAX کل سایت:** فعال یا غیرفعال کردن بارگذاری بدون رفرش صفحات برای بهبود تجربه کاربری (توجه: ممکن است با برخی افزونه‌ها ناسازگار باشد)  
- **کد بازخوانی PJAX:** کد جاوااسکریپتی که پس از بارگذاری PJAX اجرا می‌شود برای رفع مشکلات ناسازگاری افزونه‌ها  
- **فعال‌سازی رندر فرمول‌های ریاضی KaTeX**  
- **فعال‌سازی هایلایت کد prism.js**  
- **نمایش شماره خطوط در کدهای برجسته**  
- **انتخاب تم رنگی هایلایت کد**  
- **فعال‌سازی فهرست مطالب (TOC) در صفحات مقاله**  
- **وضعیت پیش‌فرض باز بودن فهرست مطالب**  
- **سبک تو رفتگی نظرات:** انتخاب بین سبک پیش‌فرض Typecho یا سبک Bubble که خوانایی بهتری دارد  
- **نمایش نام کاربری پاسخ‌دهنده در نظرات**

### کدهای کوتاه

*توجه: در صورت مشکل، لطفاً افزونه‌های شخص ثالث مانند ویرایشگرهای مقاله را غیرفعال کنید.*

#### کادرهای کد برجسته

تگ: `bbcode`  
نمونه:

```html
کادر کد سبز برای نمایش اطلاعات توصیه شده
کادر کد قرمز برای نمایش هشدار
```

#### لینک دوستان

تگ‌ها: `bblist` برای لیست و `bblink` برای هر لینک  
نمونه:

```html

  豆腐蒸锅
  Rorical

```

### تصاویر و پیش‌نمایش

تصویر پیش‌نمایش پوسته در مخزن موجود است.

### مجوز

این پوسته تحت مجوز MIT منتشر شده است.

### دیگر نکات

- پوسته توسط سه توسعه‌دهنده [TNTofu](https://github.com/trinitrotofu)، [Rorical](https://github.com/Liupaperbox) و [Totorato](https://github.com/totorato) ساخته شده است  
- بر پایه Argon Design System  
- بخش‌هایی از کدهای بخش نظرات از پوسته رسمی Typecho Default گرفته شده است  
- پوسته Rorical و نسخه اصلاح شده Bubble نیز در گیت‌هاب موجود است  

### تاریخچه به‌روزرسانی‌های مهم

| نسخه | تغییرات اصلی |
|-------|---------------|
| 4.0.1 | رفع مشکل نمایش زیرعنوان |
| 4.0.0 | تغییر به طراحی کارت‌محور، افزودن به‌روزرسانی خودکار، فهرست مطالب، دکمه بازگشت به بالا و تنظیم زیرعنوان |
| 3.0.3 | بهبود نوار پیشرفت PJAX، گرد کردن گوشه تصاویر، اصلاح حاشیه کارت‌ها، بهبود جعبه جستجو |
| 3.0.2 | تنظیم پس‌زمینه صفحه اصلی برای نمایش بهتر در صفحه‌های با رزولوشن بالا، اسکرول خودکار در صفحه اصلی هنگام تغییر صفحه |
| 3.0.1 | رفع مشکلات کارت‌های نظرات و رنگ عنوان بالای صفحه |
| 3.0.0 | افزودن پشتیبانی PJAX، کامنت بدون رفرش، رندر فرمول KaTeX، هایلایت prism.js، کدهای کوتاه، استفاده از CDN jsDelivr، بهبود ناوبری و رفع مشکلات ظاهری نظرات |
| 2.3.0 | پشتیبانی از پس‌زمینه‌های سفارشی و تصادفی، بهبود دکمه‌ها، چرخش آواتار صفحه اصلی، اصلاحات ظاهری و بروزرسانی تصاویر |
| 2.2.2 | تنظیم عرض محتوا و پشتیبانی از متن توضیح فوتر |
| 2.2.1 | رفع باگ نمایش دسته‌بندی و مرتب‌سازی کدها |
| 2.2 | بهبود تنظیم عرض محتوا و قوانین شکست خط |
| 2.1 | نمایش بخش‌های «جدیدترین نظرات»، «جدیدترین مقالات» و «آرشیو» در فوتر، افزودن دکمه ویرایش سریع برای کاربران وارد شده |
| 2.0 | طراحی کارت‌محور، بهبود نوار ناوبری، افزودن لوگو و آواتار صفحه اصلی، بهبود نمایش وضعیت مقالات، بهبود بخش نظرات، استفاده از فونت آوسام، بهبود فرم رمز عبور مقالات محافظت شده، و اصلاح مکانیزم نمایش نظرات |

اگر سوال یا نیاز به راهنمایی بیشتر داشتید، در خدمت شما هستم.