<?php
/**
 * پلاگین تبدیل اعداد لاتین به فارسی در محیط  کاربری Tyepcho
 * @package PersianNumbers
 * @author پوردریایی
 * @link https://pourdaryaei.ir/
 * @version 1.0
 */
class PersianNumbers_Plugin implements Typecho_Plugin_Interface
{
    public static function activate()
    {
        Typecho_Plugin::factory('Widget_Archive')->beforeRender = [__CLASS__, 'startBuffer'];
        Typecho_Plugin::factory('Widget_Archive')->afterRender = [__CLASS__, 'processOutput'];
    }

    public static function deactivate() {}

    public static function config(Typecho_Widget_Helper_Form $form) {}

    public static function personalConfig(Typecho_Widget_Helper_Form $form) {}

    public static function startBuffer()
    {
        ob_start();
    }

    public static function processOutput()
    {
        $content = ob_get_clean();

        // اگر خروجی HTML نیست، مستقیم چاپ کن
        if (!preg_match('/<html/i', $content)) {
            echo $content;
            return;
        }

        $dom = new DOMDocument();

        // جلوگیری از هشدارهای احتمالی HTML نامعتبر
        libxml_use_internal_errors(true);

        // بارگذاری محتوا با انکدینگ UTF-8
        $dom->loadHTML('<?xml encoding="utf-8" ?>' . $content, LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);

        libxml_clear_errors();

        // تگ‌هایی که نباید داخل آن‌ها اعداد تبدیل شوند
        $skipTags = ['code', 'pre', 'script', 'style'];

        // تابع بازگشتی برای تبدیل اعداد فقط در متن‌های مجاز
        $convertNumbers = function(DOMNode $node) use (&$convertNumbers, $skipTags) {
            // اگر والد فعلی یکی از تگ‌های استثنا بود، تبدیل نکن
            if ($node->parentNode && in_array(strtolower($node->parentNode->nodeName), $skipTags)) {
                return;
            }

            if ($node->nodeType === XML_TEXT_NODE) {
                $node->nodeValue = str_replace(
                    ['0','1','2','3','4','5','6','7','8','9'],
                    ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'],
                    $node->nodeValue
                );
            } else {
                foreach ($node->childNodes as $child) {
                    $convertNumbers($child);
                }
            }
        };

        // شروع تبدیل از ریشه سند
        $convertNumbers($dom->documentElement);

        // چاپ خروجی نهایی
        echo $dom->saveHTML();
    }
}
?>
