<?php
if (!defined('__TYPECHO_ROOT_DIR__')) exit;

/**
 * پلاگین درج خودکار ویدئو آپارات در مطالب Typecho
 * 
 * @package AparatEmbed
 * @author پوردریایی
 * @version 1.0
 * @link https://pourdaryaei.ir/
 */
class AparatEmbed_Plugin implements Typecho_Plugin_Interface
{
    /**
     * فعال‌سازی پلاگین
     */
    public static function activate()
    {
        Typecho_Plugin::factory('Widget_Abstract_Contents')->contentEx = array(__CLASS__, 'filterContent');
    }

    /**
     * غیرفعال‌سازی پلاگین
     */
    public static function deactivate() {}
 
    public static function config(Typecho_Widget_Helper_Form $form) {}
    public static function personalConfig(Typecho_Widget_Helper_Form $form) {}

    /**
     * فیلتر محتوا با پشتیبانی از نمایش رسپانسیو
     */
    public static function filterContent($content, $widget, $lastResult)
    {       
        $pattern = '#(?:<a[^>]*>)?(https?://www\.aparat\.com/v/([a-zA-Z0-9_-]+))(?:</a>)?#i';

        $content = preg_replace_callback($pattern, function($matches) {
            $videoId = $matches[2];
            $embed = '<div style="position:relative;padding-bottom:56.25%;height:0;overflow:hidden;max-width:100%;margin:15px 0;">' .
                     '<iframe src="https://www.aparat.com/video/video/embed/videohash/' . $videoId . '/vt/frame" ' .
                     'allowfullscreen style="position:absolute;top:0;left:0;width:100%;height:100%;border:none;">' .
                     '</iframe></div>';
            return $embed;
        }, $content);

        return trim($content);
    }
}